@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Caching settings for a caching-type route. To disable caching, do not provide a cacheConfiguration object.
 * @property compressionSettings compression settings.
 * @property queryParameters query parameters to include or exclude (comma separated).
 * @property queryStringCachingBehavior Defines how Frontdoor caches requests that include query strings. You can ignore any query strings when caching, ignore specific query strings, cache every request with a unique URL, or cache specific query strings.
 */
public data class AfdRouteCacheConfigurationResponse(
    public val compressionSettings: CompressionSettingsResponse? = null,
    public val queryParameters: String? = null,
    public val queryStringCachingBehavior: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.AfdRouteCacheConfigurationResponse):
            AfdRouteCacheConfigurationResponse = AfdRouteCacheConfigurationResponse(
            compressionSettings = javaType.compressionSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cdn.kotlin.outputs.CompressionSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            queryParameters = javaType.queryParameters().map({ args0 -> args0 }).orElse(null),
            queryStringCachingBehavior = javaType.queryStringCachingBehavior().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
