@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the parameters for the cache expiration action.
 * @property cacheBehavior Caching behavior for the requests
 * @property cacheDuration The duration for which the content needs to be cached. Allowed format is [d&#46;]hh:mm:ss
 * @property cacheType The level at which the content needs to be cached.
 * @property typeName
 */
public data class CacheExpirationActionParametersResponse(
    public val cacheBehavior: String,
    public val cacheDuration: String? = null,
    public val cacheType: String,
    public val typeName: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.CacheExpirationActionParametersResponse):
            CacheExpirationActionParametersResponse = CacheExpirationActionParametersResponse(
            cacheBehavior = javaType.cacheBehavior(),
            cacheDuration = javaType.cacheDuration().map({ args0 -> args0 }).orElse(null),
            cacheType = javaType.cacheType(),
            typeName = javaType.typeName(),
        )
    }
}
