@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Customer Certificate used for https
 * @property certificateAuthority Certificate issuing authority.
 * @property expirationDate Certificate expiration date.
 * @property secretSource Resource reference to the Azure Key Vault certificate. Expected to be in format of /subscriptions/{​​​​​​​​​subscriptionId}​​​​​​​​​/resourceGroups/{​​​​​​​​​resourceGroupName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/providers/Microsoft.KeyVault/vaults/{vaultName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/secrets/{certificateName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​
 * @property secretVersion Version of the secret to be used
 * @property subject Subject name in the certificate.
 * @property subjectAlternativeNames The list of SANs.
 * @property thumbprint Certificate thumbprint.
 * @property type The type of the secret resource.
 * Expected value is 'CustomerCertificate'.
 * @property useLatestVersion Whether to use the latest version for the certificate
 */
public data class CustomerCertificateParametersResponse(
    public val certificateAuthority: String,
    public val expirationDate: String,
    public val secretSource: ResourceReferenceResponse,
    public val secretVersion: String? = null,
    public val subject: String,
    public val subjectAlternativeNames: List<String>? = null,
    public val thumbprint: String,
    public val type: String,
    public val useLatestVersion: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.CustomerCertificateParametersResponse):
            CustomerCertificateParametersResponse = CustomerCertificateParametersResponse(
            certificateAuthority = javaType.certificateAuthority(),
            expirationDate = javaType.expirationDate(),
            secretSource = javaType.secretSource().let({ args0 ->
                com.pulumi.azurenative.cdn.kotlin.outputs.ResourceReferenceResponse.Companion.toKotlin(args0)
            }),
            secretVersion = javaType.secretVersion().map({ args0 -> args0 }).orElse(null),
            subject = javaType.subject(),
            subjectAlternativeNames = javaType.subjectAlternativeNames().map({ args0 -> args0 }),
            thumbprint = javaType.thumbprint(),
            type = javaType.type(),
            useLatestVersion = javaType.useLatestVersion().map({ args0 -> args0 }).orElse(null),
        )
    }
}
