@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the HostName condition for the delivery rule.
 * @property name The name of the condition for the delivery rule.
 * Expected value is 'HostName'.
 * @property parameters Defines the parameters for the condition.
 */
public data class DeliveryRuleHostNameConditionResponse(
    public val name: String,
    public val parameters: HostNameMatchConditionParametersResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.DeliveryRuleHostNameConditionResponse):
            DeliveryRuleHostNameConditionResponse = DeliveryRuleHostNameConditionResponse(
            name = javaType.name(),
            parameters = javaType.parameters().let({ args0 ->
                com.pulumi.azurenative.cdn.kotlin.outputs.HostNameMatchConditionParametersResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
