@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the request header action for the delivery rule.
 * @property name The name of the action for the delivery rule.
 * Expected value is 'ModifyRequestHeader'.
 * @property parameters Defines the parameters for the action.
 */
public data class DeliveryRuleRequestHeaderActionResponse(
    public val name: String,
    public val parameters: HeaderActionParametersResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.DeliveryRuleRequestHeaderActionResponse):
            DeliveryRuleRequestHeaderActionResponse = DeliveryRuleRequestHeaderActionResponse(
            name = javaType.name(),
            parameters = javaType.parameters().let({ args0 ->
                com.pulumi.azurenative.cdn.kotlin.outputs.HeaderActionParametersResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
