@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the RequestMethod condition for the delivery rule.
 * @property name The name of the condition for the delivery rule.
 * Expected value is 'RequestMethod'.
 * @property parameters Defines the parameters for the condition.
 */
public data class DeliveryRuleRequestMethodConditionResponse(
    public val name: String,
    public val parameters: RequestMethodMatchConditionParametersResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.DeliveryRuleRequestMethodConditionResponse):
            DeliveryRuleRequestMethodConditionResponse = DeliveryRuleRequestMethodConditionResponse(
            name = javaType.name(),
            parameters = javaType.parameters().let({ args0 ->
                com.pulumi.azurenative.cdn.kotlin.outputs.RequestMethodMatchConditionParametersResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
