@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the RequestUri condition for the delivery rule.
 * @property name The name of the condition for the delivery rule.
 * Expected value is 'RequestUri'.
 * @property parameters Defines the parameters for the condition.
 */
public data class DeliveryRuleRequestUriConditionResponse(
    public val name: String,
    public val parameters: RequestUriMatchConditionParametersResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.DeliveryRuleRequestUriConditionResponse):
            DeliveryRuleRequestUriConditionResponse = DeliveryRuleRequestUriConditionResponse(
            name = javaType.name(),
            parameters = javaType.parameters().let({ args0 ->
                com.pulumi.azurenative.cdn.kotlin.outputs.RequestUriMatchConditionParametersResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
