@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the SocketAddress condition for the delivery rule.
 * @property name The name of the condition for the delivery rule.
 * Expected value is 'SocketAddr'.
 * @property parameters Defines the parameters for the condition.
 */
public data class DeliveryRuleSocketAddrConditionResponse(
    public val name: String,
    public val parameters: SocketAddrMatchConditionParametersResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.DeliveryRuleSocketAddrConditionResponse):
            DeliveryRuleSocketAddrConditionResponse = DeliveryRuleSocketAddrConditionResponse(
            name = javaType.name(),
            parameters = javaType.parameters().let({ args0 ->
                com.pulumi.azurenative.cdn.kotlin.outputs.SocketAddrMatchConditionParametersResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
