@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the UrlFileName condition for the delivery rule.
 * @property name The name of the condition for the delivery rule.
 * Expected value is 'UrlFileName'.
 * @property parameters Defines the parameters for the condition.
 */
public data class DeliveryRuleUrlFileNameConditionResponse(
    public val name: String,
    public val parameters: UrlFileNameMatchConditionParametersResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.DeliveryRuleUrlFileNameConditionResponse):
            DeliveryRuleUrlFileNameConditionResponse = DeliveryRuleUrlFileNameConditionResponse(
            name = javaType.name(),
            parameters = javaType.parameters().let({ args0 ->
                com.pulumi.azurenative.cdn.kotlin.outputs.UrlFileNameMatchConditionParametersResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
