@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The JSON object that contains the properties to validate a domain.
 * @property expirationDate The date time that the token expires
 * @property validationToken Challenge used for DNS TXT record or file based validation
 */
public data class DomainValidationPropertiesResponse(
    public val expirationDate: String,
    public val validationToken: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.DomainValidationPropertiesResponse):
            DomainValidationPropertiesResponse = DomainValidationPropertiesResponse(
            expirationDate = javaType.expirationDate(),
            validationToken = javaType.validationToken(),
        )
    }
}
