@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Origin group comprising of origins is used for load balancing to origins when the content cannot be served from CDN.
 * @property healthProbeSettings Health probe settings to the origin that is used to determine the health of the origin.
 * @property id Resource ID.
 * @property name Resource name.
 * @property origins The source of the content being delivered via CDN within given origin group.
 * @property provisioningState Provisioning status of the origin group.
 * @property resourceState Resource status of the origin group.
 * @property responseBasedOriginErrorDetectionSettings The JSON object that contains the properties to determine origin health using real requests/responses. This property is currently not supported.
 * @property systemData Read only system data
 * @property trafficRestorationTimeToHealedOrNewEndpointsInMinutes Time in minutes to shift the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new endpoint is added. Default is 10 mins. This property is currently not supported.
 * @property type Resource type.
 */
public data class GetOriginGroupResult(
    public val healthProbeSettings: HealthProbeParametersResponse? = null,
    public val id: String,
    public val name: String,
    public val origins: List<ResourceReferenceResponse>,
    public val provisioningState: String,
    public val resourceState: String,
    public val responseBasedOriginErrorDetectionSettings:
    ResponseBasedOriginErrorDetectionParametersResponse? = null,
    public val systemData: SystemDataResponse,
    public val trafficRestorationTimeToHealedOrNewEndpointsInMinutes: Int? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.GetOriginGroupResult):
            GetOriginGroupResult = GetOriginGroupResult(
            healthProbeSettings = javaType.healthProbeSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cdn.kotlin.outputs.HealthProbeParametersResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            origins = javaType.origins().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cdn.kotlin.outputs.ResourceReferenceResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            resourceState = javaType.resourceState(),
            responseBasedOriginErrorDetectionSettings = javaType.responseBasedOriginErrorDetectionSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cdn.kotlin.outputs.ResponseBasedOriginErrorDetectionParametersResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.cdn.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            trafficRestorationTimeToHealedOrNewEndpointsInMinutes = javaType.trafficRestorationTimeToHealedOrNewEndpointsInMinutes().map({ args0 ->
                args0
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
