@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.Any
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Friendly Rules name mapping to the any Rules or secret related information.
 * @property actions A list of actions that are executed when all the conditions of a rule are satisfied.
 * @property conditions A list of conditions that must be matched for the actions to be executed
 * @property deploymentStatus
 * @property id Resource ID.
 * @property matchProcessingBehavior If this rule is a match should the rules engine continue running the remaining rules or stop. If not present, defaults to Continue.
 * @property name Resource name.
 * @property order The order in which the rules are applied for the endpoint. Possible values {0,1,2,3,………}. A rule with a lesser order will be applied before a rule with a greater order. Rule with order 0 is a special rule. It does not require any condition and actions listed in it will always be applied.
 * @property provisioningState Provisioning status
 * @property ruleSetName The name of the rule set containing the rule.
 * @property systemData Read only system data
 * @property type Resource type.
 */
public data class GetRuleResult(
    public val actions: List<Any>,
    public val conditions: List<Any>? = null,
    public val deploymentStatus: String,
    public val id: String,
    public val matchProcessingBehavior: String? = null,
    public val name: String,
    public val order: Int,
    public val provisioningState: String,
    public val ruleSetName: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.GetRuleResult): GetRuleResult =
            GetRuleResult(
                actions = javaType.actions().map({ args0 -> args0 }),
                conditions = javaType.conditions().map({ args0 -> args0 }),
                deploymentStatus = javaType.deploymentStatus(),
                id = javaType.id(),
                matchProcessingBehavior = javaType.matchProcessingBehavior().map({ args0 -> args0 }).orElse(null),
                name = javaType.name(),
                order = javaType.order(),
                provisioningState = javaType.provisioningState(),
                ruleSetName = javaType.ruleSetName(),
                systemData = javaType.systemData().let({ args0 ->
                    com.pulumi.azurenative.cdn.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
                }),
                type = javaType.type(),
            )
    }
}
