@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The JSON object that contains the properties to send health probes to origin.
 * @property probeIntervalInSeconds The number of seconds between health probes.Default is 240sec.
 * @property probePath The path relative to the origin that is used to determine the health of the origin.
 * @property probeProtocol Protocol to use for health probe.
 * @property probeRequestType The type of health probe request that is made.
 */
public data class HealthProbeParametersResponse(
    public val probeIntervalInSeconds: Int? = null,
    public val probePath: String? = null,
    public val probeProtocol: String? = null,
    public val probeRequestType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.HealthProbeParametersResponse):
            HealthProbeParametersResponse = HealthProbeParametersResponse(
            probeIntervalInSeconds = javaType.probeIntervalInSeconds().map({ args0 -> args0 }).orElse(null),
            probePath = javaType.probePath().map({ args0 -> args0 }).orElse(null),
            probeProtocol = javaType.probeProtocol().map({ args0 -> args0 }).orElse(null),
            probeRequestType = javaType.probeRequestType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
