@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines a managed rule group override setting.
 * @property action Describes the override action to be applied when rule matches.
 * @property enabledState Describes if the managed rule is in enabled or disabled state. Defaults to Disabled if not specified.
 * @property ruleId Identifier for the managed rule.
 */
public data class ManagedRuleOverrideResponse(
    public val action: String? = null,
    public val enabledState: String? = null,
    public val ruleId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.ManagedRuleOverrideResponse):
            ManagedRuleOverrideResponse = ManagedRuleOverrideResponse(
            action = javaType.action().map({ args0 -> args0 }).orElse(null),
            enabledState = javaType.enabledState().map({ args0 -> args0 }).orElse(null),
            ruleId = javaType.ruleId(),
        )
    }
}
