@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the parameters for the origin group override configuration.
 * @property forwardingProtocol Protocol this rule will use when forwarding traffic to backends.
 * @property originGroup defines the OriginGroup that would override the DefaultOriginGroup on route.
 */
public data class OriginGroupOverrideResponse(
    public val forwardingProtocol: String? = null,
    public val originGroup: ResourceReferenceResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.OriginGroupOverrideResponse):
            OriginGroupOverrideResponse = OriginGroupOverrideResponse(
            forwardingProtocol = javaType.forwardingProtocol().map({ args0 -> args0 }).orElse(null),
            originGroup = javaType.originGroup().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cdn.kotlin.outputs.ResourceReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
