@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The json object containing security policy waf parameters
 * @property associations Waf associations
 * @property type The type of the Security policy to create.
 * Expected value is 'WebApplicationFirewall'.
 * @property wafPolicy Resource ID.
 */
public data class SecurityPolicyWebApplicationFirewallParametersResponse(
    public val associations: List<SecurityPolicyWebApplicationFirewallAssociationResponse>? = null,
    public val type: String,
    public val wafPolicy: ResourceReferenceResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.SecurityPolicyWebApplicationFirewallParametersResponse):
            SecurityPolicyWebApplicationFirewallParametersResponse =
            SecurityPolicyWebApplicationFirewallParametersResponse(
                associations = javaType.associations().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.cdn.kotlin.outputs.SecurityPolicyWebApplicationFirewallAssociationResponse.Companion.toKotlin(args0)
                    })
                }),
                type = javaType.type(),
                wafPolicy = javaType.wafPolicy().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.cdn.kotlin.outputs.ResourceReferenceResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
