@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes the properties of an existing Shared Private Link Resource to use when connecting to a private origin.
 * @property groupId The group id from the provider of resource the shared private link resource is for.
 * @property privateLink The resource id of the resource the shared private link resource is for.
 * @property privateLinkLocation The location of the shared private link resource
 * @property requestMessage The request message for requesting approval of the shared private link resource.
 * @property status Status of the shared private link resource. Can be Pending, Approved, Rejected, Disconnected, or Timeout.
 */
public data class SharedPrivateLinkResourcePropertiesResponse(
    public val groupId: String? = null,
    public val privateLink: ResourceReferenceResponse? = null,
    public val privateLinkLocation: String? = null,
    public val requestMessage: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.SharedPrivateLinkResourcePropertiesResponse):
            SharedPrivateLinkResourcePropertiesResponse = SharedPrivateLinkResourcePropertiesResponse(
            groupId = javaType.groupId().map({ args0 -> args0 }).orElse(null),
            privateLink = javaType.privateLink().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cdn.kotlin.outputs.ResourceReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            privateLinkLocation = javaType.privateLinkLocation().map({ args0 -> args0 }).orElse(null),
            requestMessage = javaType.requestMessage().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
