@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Standard_Verizon = The SKU name for a Standard Verizon CDN profile.
 * Premium_Verizon = The SKU name for a Premium Verizon CDN profile.
 * Custom_Verizon = The SKU name for a Custom Verizon CDN profile.
 * Standard_Akamai = The SKU name for an Akamai CDN profile.
 * Standard_ChinaCdn = The SKU name for a China CDN profile for VOD, Web and download scenarios using GB based billing model.
 * Standard_Microsoft = The SKU name for a Standard Microsoft CDN profile.
 * Standard_AzureFrontDoor =  The SKU name for an Azure Front Door Standard profile.
 * Premium_AzureFrontDoor = The SKU name for an Azure Front Door Premium profile.
 * Standard_955BandWidth_ChinaCdn = The SKU name for a China CDN profile for VOD, Web and download scenarios using 95-5 peak bandwidth billing model.
 * Standard_AvgBandWidth_ChinaCdn = The SKU name for a China CDN profile for VOD, Web and download scenarios using monthly average peak bandwidth billing model.
 * StandardPlus_ChinaCdn = The SKU name for a China CDN profile for live-streaming using GB based billing model.
 * StandardPlus_955BandWidth_ChinaCdn = The SKU name for a China CDN live-streaming profile using 95-5 peak bandwidth billing model.
 * StandardPlus_AvgBandWidth_ChinaCdn = The SKU name for a China CDN live-streaming profile using monthly average peak bandwidth billing model.
 * @property name Name of the pricing tier.
 */
public data class SkuResponse(
    public val name: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.outputs.SkuResponse): SkuResponse =
            SkuResponse(
                name = javaType.name().map({ args0 -> args0 }).orElse(null),
            )
    }
}
