@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.certificateregistration.kotlin

import com.pulumi.azurenative.certificateregistration.AppServiceCertificateOrderCertificateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Key Vault container ARM resource for a certificate that is purchased through Azure.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-10-01.
 * Other available API versions: 2020-10-01, 2023-01-01.
 * ## Example Usage
 * ### Create Certificate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var appServiceCertificateOrderCertificate = new AzureNative.CertificateRegistration.AppServiceCertificateOrderCertificate("appServiceCertificateOrderCertificate", new()
 *     {
 *         CertificateOrderName = "SampleCertificateOrderName",
 *         KeyVaultId = "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/testrg123/providers/microsoft.keyvault/vaults/SamplevaultName",
 *         KeyVaultSecretName = "SampleSecretName1",
 *         Location = "Global",
 *         Name = "SampleCertName1",
 *         ResourceGroupName = "testrg123",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/certificateregistration/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := certificateregistration.NewAppServiceCertificateOrderCertificate(ctx, "appServiceCertificateOrderCertificate", &certificateregistration.AppServiceCertificateOrderCertificateArgs{
 * 			CertificateOrderName: pulumi.String("SampleCertificateOrderName"),
 * 			KeyVaultId:           pulumi.String("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/testrg123/providers/microsoft.keyvault/vaults/SamplevaultName"),
 * 			KeyVaultSecretName:   pulumi.String("SampleSecretName1"),
 * 			Location:             pulumi.String("Global"),
 * 			Name:                 pulumi.String("SampleCertName1"),
 * 			ResourceGroupName:    pulumi.String("testrg123"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.certificateregistration.AppServiceCertificateOrderCertificate;
 * import com.pulumi.azurenative.certificateregistration.AppServiceCertificateOrderCertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var appServiceCertificateOrderCertificate = new AppServiceCertificateOrderCertificate("appServiceCertificateOrderCertificate", AppServiceCertificateOrderCertificateArgs.builder()
 *             .certificateOrderName("SampleCertificateOrderName")
 *             .keyVaultId("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/testrg123/providers/microsoft.keyvault/vaults/SamplevaultName")
 *             .keyVaultSecretName("SampleSecretName1")
 *             .location("Global")
 *             .name("SampleCertName1")
 *             .resourceGroupName("testrg123")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:certificateregistration:AppServiceCertificateOrderCertificate SampleCertName1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/certificates/{name}
 * ```
 * @property certificateOrderName Name of the certificate order.
 * @property keyVaultId Key Vault resource Id.
 * @property keyVaultSecretName Key Vault secret name.
 * @property kind Kind of resource.
 * @property location Resource Location.
 * @property name Name of the certificate.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 * @property tags Resource tags.
 */
public data class AppServiceCertificateOrderCertificateArgs(
    public val certificateOrderName: Output<String>? = null,
    public val keyVaultId: Output<String>? = null,
    public val keyVaultSecretName: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.certificateregistration.AppServiceCertificateOrderCertificateArgs> {
    override fun toJava():
        com.pulumi.azurenative.certificateregistration.AppServiceCertificateOrderCertificateArgs =
        com.pulumi.azurenative.certificateregistration.AppServiceCertificateOrderCertificateArgs.builder()
            .certificateOrderName(certificateOrderName?.applyValue({ args0 -> args0 }))
            .keyVaultId(keyVaultId?.applyValue({ args0 -> args0 }))
            .keyVaultSecretName(keyVaultSecretName?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AppServiceCertificateOrderCertificateArgs].
 */
@PulumiTagMarker
public class AppServiceCertificateOrderCertificateArgsBuilder internal constructor() {
    private var certificateOrderName: Output<String>? = null

    private var keyVaultId: Output<String>? = null

    private var keyVaultSecretName: Output<String>? = null

    private var kind: Output<String>? = null

    private var location: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Name of the certificate order.
     */
    @JvmName("nkumgwpmtnhnwkuq")
    public suspend fun certificateOrderName(`value`: Output<String>) {
        this.certificateOrderName = value
    }

    /**
     * @param value Key Vault resource Id.
     */
    @JvmName("hosaenqwaeffdguv")
    public suspend fun keyVaultId(`value`: Output<String>) {
        this.keyVaultId = value
    }

    /**
     * @param value Key Vault secret name.
     */
    @JvmName("tlautvkcxgvkoovl")
    public suspend fun keyVaultSecretName(`value`: Output<String>) {
        this.keyVaultSecretName = value
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("ieddaukbktvtxqbx")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Resource Location.
     */
    @JvmName("jeppbwnjpvuxsdld")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of the certificate.
     */
    @JvmName("pkycpudtuxdtikmv")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("ptdgwligywchyxsh")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("owuoccmcswnjkgsa")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of the certificate order.
     */
    @JvmName("kmiynnitbkhuxtkk")
    public suspend fun certificateOrderName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateOrderName = mapped
    }

    /**
     * @param value Key Vault resource Id.
     */
    @JvmName("oabfijcdbdaghcmj")
    public suspend fun keyVaultId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultId = mapped
    }

    /**
     * @param value Key Vault secret name.
     */
    @JvmName("bxsqvpjrebgotfmh")
    public suspend fun keyVaultSecretName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultSecretName = mapped
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("hytcuciictqgljsd")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Resource Location.
     */
    @JvmName("lutprkgcrisgaitf")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of the certificate.
     */
    @JvmName("lsbgxgehcbmngbil")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("bvsirjqnxphcufka")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("hdtnelgcunoqjoxj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("igjyxydameamwjvb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AppServiceCertificateOrderCertificateArgs =
        AppServiceCertificateOrderCertificateArgs(
            certificateOrderName = certificateOrderName,
            keyVaultId = keyVaultId,
            keyVaultSecretName = keyVaultSecretName,
            kind = kind,
            location = location,
            name = name,
            resourceGroupName = resourceGroupName,
            tags = tags,
        )
}
