@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.changeanalysis.kotlin

import com.pulumi.azurenative.changeanalysis.ChangeanalysisFunctions.getConfigurationProfilePlain
import com.pulumi.azurenative.changeanalysis.kotlin.inputs.GetConfigurationProfilePlainArgs
import com.pulumi.azurenative.changeanalysis.kotlin.inputs.GetConfigurationProfilePlainArgsBuilder
import com.pulumi.azurenative.changeanalysis.kotlin.outputs.GetConfigurationProfileResult
import com.pulumi.azurenative.changeanalysis.kotlin.outputs.GetConfigurationProfileResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

public object ChangeanalysisFunctions {
    /**
     * A profile object that contains change analysis configuration, such as notification settings, for this subscription
     * Azure REST API version: 2020-04-01-preview.
     * @param argument null
     * @return A profile object that contains change analysis configuration, such as notification settings, for this subscription
     */
    public suspend fun getConfigurationProfile(argument: GetConfigurationProfilePlainArgs):
        GetConfigurationProfileResult =
        toKotlin(getConfigurationProfilePlain(argument.toJava()).await())

    /**
     * @see [getConfigurationProfile].
     * @param profileName The name of the configuration profile. The profile name should be set to 'default', all other names will be overwritten.
     * @return A profile object that contains change analysis configuration, such as notification settings, for this subscription
     */
    public suspend fun getConfigurationProfile(profileName: String): GetConfigurationProfileResult {
        val argument = GetConfigurationProfilePlainArgs(
            profileName = profileName,
        )
        return toKotlin(getConfigurationProfilePlain(argument.toJava()).await())
    }

    /**
     * @see [getConfigurationProfile].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;changeanalysis&#46;kotlin&#46;inputs&#46;GetConfigurationProfilePlainArgs].
     * @return A profile object that contains change analysis configuration, such as notification settings, for this subscription
     */
    public suspend
    fun getConfigurationProfile(argument: suspend GetConfigurationProfilePlainArgsBuilder.() -> Unit):
        GetConfigurationProfileResult {
        val builder = GetConfigurationProfilePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getConfigurationProfilePlain(builtArgument.toJava()).await())
    }
}
