@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.changeanalysis.kotlin

import com.pulumi.azurenative.changeanalysis.ConfigurationProfileArgs.builder
import com.pulumi.azurenative.changeanalysis.kotlin.inputs.ConfigurationProfileResourcePropertiesArgs
import com.pulumi.azurenative.changeanalysis.kotlin.inputs.ConfigurationProfileResourcePropertiesArgsBuilder
import com.pulumi.azurenative.changeanalysis.kotlin.inputs.ResourceIdentityArgs
import com.pulumi.azurenative.changeanalysis.kotlin.inputs.ResourceIdentityArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A profile object that contains change analysis configuration, such as notification settings, for this subscription
 * Azure REST API version: 2020-04-01-preview. Prior API version in Azure Native 1.x: 2020-04-01-preview.
 * ## Example Usage
 * ### ConfigurationProfile_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var configurationProfile = new AzureNative.ChangeAnalysis.ConfigurationProfile("configurationProfile", new()
 *     {
 *         ProfileName = "default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/changeanalysis/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := changeanalysis.NewConfigurationProfile(ctx, "configurationProfile", &changeanalysis.ConfigurationProfileArgs{
 * 			ProfileName: pulumi.String("default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.changeanalysis.ConfigurationProfile;
 * import com.pulumi.azurenative.changeanalysis.ConfigurationProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var configurationProfile = new ConfigurationProfile("configurationProfile", ConfigurationProfileArgs.builder()
 *             .profileName("default")
 *             .build());
 *     }
 * }
 * ```
 * ### ConfigurationProfile_CreateWithIdentity
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var configurationProfile = new AzureNative.ChangeAnalysis.ConfigurationProfile("configurationProfile", new()
 *     {
 *         ProfileName = "default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/changeanalysis/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := changeanalysis.NewConfigurationProfile(ctx, "configurationProfile", &changeanalysis.ConfigurationProfileArgs{
 * 			ProfileName: pulumi.String("default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.changeanalysis.ConfigurationProfile;
 * import com.pulumi.azurenative.changeanalysis.ConfigurationProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var configurationProfile = new ConfigurationProfile("configurationProfile", ConfigurationProfileArgs.builder()
 *             .profileName("default")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:changeanalysis:ConfigurationProfile default /subscriptions/{subscriptionId}/providers/Microsoft.ChangeAnalysis/profile/{profileName}
 * ```
 * @property identity The identity block returned by ARM resource that supports managed identity.
 * @property location The location where the resource is to be deployed.
 * @property profileName The name of the configuration profile. The profile name should be set to 'default', all other names will be overwritten.
 * @property properties The properties of a configuration profile.
 */
public data class ConfigurationProfileArgs(
    public val identity: Output<ResourceIdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val profileName: Output<String>? = null,
    public val properties: Output<ConfigurationProfileResourcePropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.changeanalysis.ConfigurationProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.changeanalysis.ConfigurationProfileArgs =
        com.pulumi.azurenative.changeanalysis.ConfigurationProfileArgs.builder()
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .profileName(profileName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ConfigurationProfileArgs].
 */
@PulumiTagMarker
public class ConfigurationProfileArgsBuilder internal constructor() {
    private var identity: Output<ResourceIdentityArgs>? = null

    private var location: Output<String>? = null

    private var profileName: Output<String>? = null

    private var properties: Output<ConfigurationProfileResourcePropertiesArgs>? = null

    /**
     * @param value The identity block returned by ARM resource that supports managed identity.
     */
    @JvmName("kvplupmgafjrbtbb")
    public suspend fun identity(`value`: Output<ResourceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The location where the resource is to be deployed.
     */
    @JvmName("ougbvrqongciljgx")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the configuration profile. The profile name should be set to 'default', all other names will be overwritten.
     */
    @JvmName("firkbiibodhmrmau")
    public suspend fun profileName(`value`: Output<String>) {
        this.profileName = value
    }

    /**
     * @param value The properties of a configuration profile.
     */
    @JvmName("oblecqjjiwhjivib")
    public suspend fun properties(`value`: Output<ConfigurationProfileResourcePropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The identity block returned by ARM resource that supports managed identity.
     */
    @JvmName("rscktgojxlqwpsgv")
    public suspend fun identity(`value`: ResourceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The identity block returned by ARM resource that supports managed identity.
     */
    @JvmName("wirokdtqinpfasie")
    public suspend fun identity(argument: suspend ResourceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The location where the resource is to be deployed.
     */
    @JvmName("pqyasdrltavsmmnn")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the configuration profile. The profile name should be set to 'default', all other names will be overwritten.
     */
    @JvmName("lmyncnoqhhcsxpsr")
    public suspend fun profileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.profileName = mapped
    }

    /**
     * @param value The properties of a configuration profile.
     */
    @JvmName("docvfigetygxtmcv")
    public suspend fun properties(`value`: ConfigurationProfileResourcePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument The properties of a configuration profile.
     */
    @JvmName("eanauqmggrxaxtun")
    public suspend
    fun properties(argument: suspend ConfigurationProfileResourcePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ConfigurationProfileResourcePropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    internal fun build(): ConfigurationProfileArgs = ConfigurationProfileArgs(
        identity = identity,
        location = location,
        profileName = profileName,
        properties = properties,
    )
}
