@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.changeanalysis.kotlin.inputs

import com.pulumi.azurenative.changeanalysis.inputs.ResourceIdentityArgs.builder
import com.pulumi.azurenative.changeanalysis.kotlin.enums.ManagedIdentityTypes
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The identity block returned by ARM resource that supports managed identity.
 * @property type The type of managed identity used. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user-assigned identities. The type 'None' will remove any identities.
 */
public data class ResourceIdentityArgs(
    public val type: Output<Either<String, ManagedIdentityTypes>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.changeanalysis.inputs.ResourceIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.changeanalysis.inputs.ResourceIdentityArgs =
        com.pulumi.azurenative.changeanalysis.inputs.ResourceIdentityArgs.builder()
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ResourceIdentityArgs].
 */
@PulumiTagMarker
public class ResourceIdentityArgsBuilder internal constructor() {
    private var type: Output<Either<String, ManagedIdentityTypes>>? = null

    /**
     * @param value The type of managed identity used. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user-assigned identities. The type 'None' will remove any identities.
     */
    @JvmName("yermqcwulawvqgke")
    public suspend fun type(`value`: Output<Either<String, ManagedIdentityTypes>>) {
        this.type = value
    }

    /**
     * @param value The type of managed identity used. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user-assigned identities. The type 'None' will remove any identities.
     */
    @JvmName("nvqrgtnrkcqbhtfk")
    public suspend fun type(`value`: Either<String, ManagedIdentityTypes>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of managed identity used. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user-assigned identities. The type 'None' will remove any identities.
     */
    @JvmName("comtopxafecojrib")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ManagedIdentityTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of managed identity used. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user-assigned identities. The type 'None' will remove any identities.
     */
    @JvmName("ijxgxydqwrmmfjgj")
    public fun type(`value`: ManagedIdentityTypes) {
        val toBeMapped = Either.ofRight<String, ManagedIdentityTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ResourceIdentityArgs = ResourceIdentityArgs(
        type = type,
    )
}
