@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.changeanalysis.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A profile object that contains change analysis configuration, such as notification settings, for this subscription
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property identity The identity block returned by ARM resource that supports managed identity.
 * @property location The location where the resource is to be deployed.
 * @property name The name of the resource
 * @property properties The properties of a configuration profile.
 * @property systemData Top level metadata https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/common-api-contracts.md#system-metadata-for-all-azure-resources
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetConfigurationProfileResult(
    public val id: String,
    public val identity: ResourceIdentityResponse? = null,
    public val location: String? = null,
    public val name: String,
    public val properties: ConfigurationProfileResourcePropertiesResponse,
    public val systemData: SystemDataResponse? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.changeanalysis.outputs.GetConfigurationProfileResult):
            GetConfigurationProfileResult = GetConfigurationProfileResult(
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.changeanalysis.kotlin.outputs.ResourceIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.changeanalysis.kotlin.outputs.ConfigurationProfileResourcePropertiesResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.changeanalysis.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
