@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.changeanalysis.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Settings of change notification configuration for a subscription.
 * @property activationState The state of notifications feature.
 * @property azureMonitorWorkspaceProperties Configuration properties of an Azure Monitor workspace that receives change notifications.
 */
public data class NotificationSettingsResponse(
    public val activationState: String? = null,
    public val azureMonitorWorkspaceProperties: AzureMonitorWorkspacePropertiesResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.changeanalysis.outputs.NotificationSettingsResponse):
            NotificationSettingsResponse = NotificationSettingsResponse(
            activationState = javaType.activationState().map({ args0 -> args0 }).orElse(null),
            azureMonitorWorkspaceProperties = javaType.azureMonitorWorkspaceProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.changeanalysis.kotlin.outputs.AzureMonitorWorkspacePropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
