@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.changeanalysis.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Top level metadata https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/common-api-contracts.md#system-metadata-for-all-azure-resources
 * @property createdAt The timestamp of resource creation (UTC)
 * @property createdBy A string identifier for the identity that created the resource
 * @property createdByType The type of identity that created the resource: user, application, managedIdentity, key
 * @property lastModifiedAt The timestamp of resource last modification (UTC)
 * @property lastModifiedBy A string identifier for the identity that last modified the resource
 * @property lastModifiedByType The type of identity that last modified the resource: user, application, managedIdentity, key
 */
public data class SystemDataResponse(
    public val createdAt: String,
    public val createdBy: String,
    public val createdByType: String,
    public val lastModifiedAt: String,
    public val lastModifiedBy: String,
    public val lastModifiedByType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.changeanalysis.outputs.SystemDataResponse):
            SystemDataResponse = SystemDataResponse(
            createdAt = javaType.createdAt(),
            createdBy = javaType.createdBy(),
            createdByType = javaType.createdByType(),
            lastModifiedAt = javaType.lastModifiedAt(),
            lastModifiedBy = javaType.lastModifiedBy(),
            lastModifiedByType = javaType.lastModifiedByType(),
        )
    }
}
