@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.chaos.kotlin.inputs

import com.pulumi.azurenative.chaos.inputs.BranchArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Model that represents a branch in the step.
 * @property actions List of actions.
 * @property name String of the branch name.
 */
public data class BranchArgs(
    public val actions: Output<List<Any>>,
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.chaos.inputs.BranchArgs> {
    override fun toJava(): com.pulumi.azurenative.chaos.inputs.BranchArgs =
        com.pulumi.azurenative.chaos.inputs.BranchArgs.builder()
            .actions(actions.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BranchArgs].
 */
@PulumiTagMarker
public class BranchArgsBuilder internal constructor() {
    private var actions: Output<List<Any>>? = null

    private var name: Output<String>? = null

    /**
     * @param value List of actions.
     */
    @JvmName("edavonxypfgaluyd")
    public suspend fun actions(`value`: Output<List<Any>>) {
        this.actions = value
    }

    @JvmName("tgkcjncrbfoctrin")
    public suspend fun actions(vararg values: Output<Any>) {
        this.actions = Output.all(values.asList())
    }

    /**
     * @param values List of actions.
     */
    @JvmName("wycqjykgpwmmyooo")
    public suspend fun actions(values: List<Output<Any>>) {
        this.actions = Output.all(values)
    }

    /**
     * @param value String of the branch name.
     */
    @JvmName("ujoqydujbbaeugax")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value List of actions.
     */
    @JvmName("iwtfawbuweykogyd")
    public suspend fun actions(`value`: List<Any>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param values List of actions.
     */
    @JvmName("ctenvwpoygxnpjix")
    public suspend fun actions(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param value String of the branch name.
     */
    @JvmName("tiadexkqebyfxyxp")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): BranchArgs = BranchArgs(
        actions = actions ?: throw PulumiNullFieldException("actions"),
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
