@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.chaos.kotlin.inputs

import com.pulumi.azurenative.chaos.inputs.GetCapabilityPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property capabilityName String that represents a Capability resource name.
 * @property parentProviderNamespace String that represents a resource provider namespace.
 * @property parentResourceName String that represents a resource name.
 * @property parentResourceType String that represents a resource type.
 * @property resourceGroupName String that represents an Azure resource group.
 * @property targetName String that represents a Target resource name.
 */
public data class GetCapabilityPlainArgs(
    public val capabilityName: String,
    public val parentProviderNamespace: String,
    public val parentResourceName: String,
    public val parentResourceType: String,
    public val resourceGroupName: String,
    public val targetName: String,
) : ConvertibleToJava<com.pulumi.azurenative.chaos.inputs.GetCapabilityPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.chaos.inputs.GetCapabilityPlainArgs =
        com.pulumi.azurenative.chaos.inputs.GetCapabilityPlainArgs.builder()
            .capabilityName(capabilityName.let({ args0 -> args0 }))
            .parentProviderNamespace(parentProviderNamespace.let({ args0 -> args0 }))
            .parentResourceName(parentResourceName.let({ args0 -> args0 }))
            .parentResourceType(parentResourceType.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .targetName(targetName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCapabilityPlainArgs].
 */
@PulumiTagMarker
public class GetCapabilityPlainArgsBuilder internal constructor() {
    private var capabilityName: String? = null

    private var parentProviderNamespace: String? = null

    private var parentResourceName: String? = null

    private var parentResourceType: String? = null

    private var resourceGroupName: String? = null

    private var targetName: String? = null

    /**
     * @param value String that represents a Capability resource name.
     */
    @JvmName("tmqtfvbfiavpprbe")
    public suspend fun capabilityName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.capabilityName = mapped
    }

    /**
     * @param value String that represents a resource provider namespace.
     */
    @JvmName("jhywqaelxsjsmhii")
    public suspend fun parentProviderNamespace(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.parentProviderNamespace = mapped
    }

    /**
     * @param value String that represents a resource name.
     */
    @JvmName("wgmvoldgkeetkgpu")
    public suspend fun parentResourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.parentResourceName = mapped
    }

    /**
     * @param value String that represents a resource type.
     */
    @JvmName("vjdhejcyobgrcbuo")
    public suspend fun parentResourceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.parentResourceType = mapped
    }

    /**
     * @param value String that represents an Azure resource group.
     */
    @JvmName("tbumpoydncekpfwc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value String that represents a Target resource name.
     */
    @JvmName("aofdirihbwgqafht")
    public suspend fun targetName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.targetName = mapped
    }

    internal fun build(): GetCapabilityPlainArgs = GetCapabilityPlainArgs(
        capabilityName = capabilityName ?: throw PulumiNullFieldException("capabilityName"),
        parentProviderNamespace = parentProviderNamespace ?: throw
            PulumiNullFieldException("parentProviderNamespace"),
        parentResourceName = parentResourceName ?: throw PulumiNullFieldException("parentResourceName"),
        parentResourceType = parentResourceType ?: throw PulumiNullFieldException("parentResourceType"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        targetName = targetName ?: throw PulumiNullFieldException("targetName"),
    )
}
