@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.chaos.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Model that represents the Experiment action target details properties model.
 * @property error The error of the action.
 * @property status The status of the execution.
 * @property target The target for the action.
 * @property targetCompletedTime String that represents the completed date time.
 * @property targetFailedTime String that represents the failed date time.
 */
public data class ExperimentExecutionActionTargetDetailsPropertiesResponse(
    public val error: ExperimentExecutionActionTargetDetailsErrorResponse,
    public val status: String,
    public val target: String,
    public val targetCompletedTime: String,
    public val targetFailedTime: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.chaos.outputs.ExperimentExecutionActionTargetDetailsPropertiesResponse):
            ExperimentExecutionActionTargetDetailsPropertiesResponse =
            ExperimentExecutionActionTargetDetailsPropertiesResponse(
                error = javaType.error().let({ args0 ->
                    com.pulumi.azurenative.chaos.kotlin.outputs.ExperimentExecutionActionTargetDetailsErrorResponse.Companion.toKotlin(args0)
                }),
                status = javaType.status(),
                target = javaType.target(),
                targetCompletedTime = javaType.targetCompletedTime(),
                targetFailedTime = javaType.targetFailedTime(),
            )
    }
}
