@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.chaos.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Model that represents the execution details of an Experiment.
 * @property failureReason The reason why the execution failed.
 * @property id String of the fully qualified resource ID.
 * @property lastActionAt String that represents the last action date time.
 * @property name String of the resource name.
 * @property runInformation The information of the experiment run.
 * @property startedAt String that represents the start date time.
 * @property status The status of the execution.
 * @property stoppedAt String that represents the stop date time.
 * @property type String of the resource type.
 */
public data class GetExperimentExecutionDetailsResult(
    public val failureReason: String,
    public val id: String,
    public val lastActionAt: String,
    public val name: String,
    public val runInformation: ExperimentExecutionDetailsPropertiesResponseRunInformation,
    public val startedAt: String,
    public val status: String,
    public val stoppedAt: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.chaos.outputs.GetExperimentExecutionDetailsResult):
            GetExperimentExecutionDetailsResult = GetExperimentExecutionDetailsResult(
            failureReason = javaType.failureReason(),
            id = javaType.id(),
            lastActionAt = javaType.lastActionAt(),
            name = javaType.name(),
            runInformation = javaType.runInformation().let({ args0 ->
                com.pulumi.azurenative.chaos.kotlin.outputs.ExperimentExecutionDetailsPropertiesResponseRunInformation.Companion.toKotlin(args0)
            }),
            startedAt = javaType.startedAt(),
            status = javaType.status(),
            stoppedAt = javaType.stoppedAt(),
            type = javaType.type(),
        )
    }
}
