@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.chaos.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Model that represents a query selector.
 * @property filter Model that represents available filter types that can be applied to a targets list.
 * @property id String of the selector ID.
 * @property queryString Azure Resource Graph (ARG) Query Language query for target resources.
 * @property subscriptionIds Subscription id list to scope resource query.
 * @property type Enum of the selector type.
 * Expected value is 'Query'.
 */
public data class QuerySelectorResponse(
    public val filter: SimpleFilterResponse? = null,
    public val id: String,
    public val queryString: String,
    public val subscriptionIds: List<String>,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.chaos.outputs.QuerySelectorResponse):
            QuerySelectorResponse = QuerySelectorResponse(
            filter = javaType.filter().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.chaos.kotlin.outputs.SimpleFilterResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            queryString = javaType.queryString(),
            subscriptionIds = javaType.subscriptionIds().map({ args0 -> args0 }),
            type = javaType.type(),
        )
    }
}
