@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.chaos.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Model that represents a reference to a Target in the selector.
 * @property id String of the resource ID of a Target resource.
 * @property type Enum of the Target reference type.
 */
public data class TargetReferenceResponse(
    public val id: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.chaos.outputs.TargetReferenceResponse):
            TargetReferenceResponse = TargetReferenceResponse(
            id = javaType.id(),
            type = javaType.type(),
        )
    }
}
