@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin

import com.pulumi.azurenative.cognitiveservices.kotlin.outputs.EncryptionScopePropertiesResponse
import com.pulumi.azurenative.cognitiveservices.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.cognitiveservices.kotlin.outputs.EncryptionScopePropertiesResponse.Companion.toKotlin as encryptionScopePropertiesResponseToKotlin
import com.pulumi.azurenative.cognitiveservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [EncryptionScope].
 */
@PulumiTagMarker
public class EncryptionScopeResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EncryptionScopeArgs = EncryptionScopeArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EncryptionScopeArgsBuilder.() -> Unit) {
        val builder = EncryptionScopeArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): EncryptionScope {
        val builtJavaResource =
            com.pulumi.azurenative.cognitiveservices.EncryptionScope(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return EncryptionScope(builtJavaResource)
    }
}

/**
 * Cognitive Services EncryptionScope
 * Azure REST API version: 2023-10-01-preview.
 * ## Example Usage
 * ### PutEncryptionScope
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var encryptionScope = new AzureNative.CognitiveServices.EncryptionScope("encryptionScope", new()
 *     {
 *         AccountName = "accountName",
 *         EncryptionScopeName = "encryptionScopeName",
 *         Properties = new AzureNative.CognitiveServices.Inputs.EncryptionScopePropertiesArgs
 *         {
 *             KeySource = "Microsoft.KeyVault",
 *             KeyVaultProperties = new AzureNative.CognitiveServices.Inputs.KeyVaultPropertiesArgs
 *             {
 *                 IdentityClientId = "00000000-0000-0000-0000-000000000000",
 *                 KeyName = "DevKeyWestUS2",
 *                 KeyVaultUri = "https://devkvwestus2.vault.azure.net/",
 *                 KeyVersion = "9f85549d7bf14ff4bf178c10d3bdca95",
 *             },
 *             State = "Enabled",
 *         },
 *         ResourceGroupName = "resourceGroupName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cognitiveservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cognitiveservices.NewEncryptionScope(ctx, "encryptionScope", &cognitiveservices.EncryptionScopeArgs{
 * 			AccountName:         pulumi.String("accountName"),
 * 			EncryptionScopeName: pulumi.String("encryptionScopeName"),
 * 			Properties: cognitiveservices.EncryptionScopePropertiesResponse{
 * 				KeySource: pulumi.String("Microsoft.KeyVault"),
 * 				KeyVaultProperties: &cognitiveservices.KeyVaultPropertiesArgs{
 * 					IdentityClientId: pulumi.String("00000000-0000-0000-0000-000000000000"),
 * 					KeyName:          pulumi.String("DevKeyWestUS2"),
 * 					KeyVaultUri:      pulumi.String("https://devkvwestus2.vault.azure.net/"),
 * 					KeyVersion:       pulumi.String("9f85549d7bf14ff4bf178c10d3bdca95"),
 * 				},
 * 				State: pulumi.String("Enabled"),
 * 			},
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cognitiveservices.EncryptionScope;
 * import com.pulumi.azurenative.cognitiveservices.EncryptionScopeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var encryptionScope = new EncryptionScope("encryptionScope", EncryptionScopeArgs.builder()
 *             .accountName("accountName")
 *             .encryptionScopeName("encryptionScopeName")
 *             .properties(Map.ofEntries(
 *                 Map.entry("keySource", "Microsoft.KeyVault"),
 *                 Map.entry("keyVaultProperties", Map.ofEntries(
 *                     Map.entry("identityClientId", "00000000-0000-0000-0000-000000000000"),
 *                     Map.entry("keyName", "DevKeyWestUS2"),
 *                     Map.entry("keyVaultUri", "https://devkvwestus2.vault.azure.net/"),
 *                     Map.entry("keyVersion", "9f85549d7bf14ff4bf178c10d3bdca95")
 *                 )),
 *                 Map.entry("state", "Enabled")
 *             ))
 *             .resourceGroupName("resourceGroupName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cognitiveservices:EncryptionScope encryptionScopeName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CognitiveServices/accounts/{accountName}/encryptionScopes/{encryptionScopeName}
 * ```
 */
public class EncryptionScope internal constructor(
    override val javaResource: com.pulumi.azurenative.cognitiveservices.EncryptionScope,
) : KotlinCustomResource(javaResource, EncryptionScopeMapper) {
    /**
     * Resource Etag.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties of Cognitive Services EncryptionScope.
     */
    public val properties: Output<EncryptionScopePropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                encryptionScopePropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object EncryptionScopeMapper : ResourceMapper<EncryptionScope> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.cognitiveservices.EncryptionScope::class == javaResource::class

    override fun map(javaResource: Resource): EncryptionScope = EncryptionScope(
        javaResource as
            com.pulumi.azurenative.cognitiveservices.EncryptionScope,
    )
}

/**
 * @see [EncryptionScope].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EncryptionScope].
 */
public suspend fun encryptionScope(
    name: String,
    block: suspend EncryptionScopeResourceBuilder.() -> Unit,
): EncryptionScope {
    val builder = EncryptionScopeResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EncryptionScope].
 * @param name The _unique_ name of the resulting resource.
 */
public fun encryptionScope(name: String): EncryptionScope {
    val builder = EncryptionScopeResourceBuilder()
    builder.name(name)
    return builder.build()
}
