@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin

import com.pulumi.azurenative.cognitiveservices.EncryptionScopeArgs.builder
import com.pulumi.azurenative.cognitiveservices.kotlin.inputs.EncryptionScopePropertiesArgs
import com.pulumi.azurenative.cognitiveservices.kotlin.inputs.EncryptionScopePropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Cognitive Services EncryptionScope
 * Azure REST API version: 2023-10-01-preview.
 * ## Example Usage
 * ### PutEncryptionScope
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var encryptionScope = new AzureNative.CognitiveServices.EncryptionScope("encryptionScope", new()
 *     {
 *         AccountName = "accountName",
 *         EncryptionScopeName = "encryptionScopeName",
 *         Properties = new AzureNative.CognitiveServices.Inputs.EncryptionScopePropertiesArgs
 *         {
 *             KeySource = "Microsoft.KeyVault",
 *             KeyVaultProperties = new AzureNative.CognitiveServices.Inputs.KeyVaultPropertiesArgs
 *             {
 *                 IdentityClientId = "00000000-0000-0000-0000-000000000000",
 *                 KeyName = "DevKeyWestUS2",
 *                 KeyVaultUri = "https://devkvwestus2.vault.azure.net/",
 *                 KeyVersion = "9f85549d7bf14ff4bf178c10d3bdca95",
 *             },
 *             State = "Enabled",
 *         },
 *         ResourceGroupName = "resourceGroupName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cognitiveservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cognitiveservices.NewEncryptionScope(ctx, "encryptionScope", &cognitiveservices.EncryptionScopeArgs{
 * 			AccountName:         pulumi.String("accountName"),
 * 			EncryptionScopeName: pulumi.String("encryptionScopeName"),
 * 			Properties: cognitiveservices.EncryptionScopePropertiesResponse{
 * 				KeySource: pulumi.String("Microsoft.KeyVault"),
 * 				KeyVaultProperties: &cognitiveservices.KeyVaultPropertiesArgs{
 * 					IdentityClientId: pulumi.String("00000000-0000-0000-0000-000000000000"),
 * 					KeyName:          pulumi.String("DevKeyWestUS2"),
 * 					KeyVaultUri:      pulumi.String("https://devkvwestus2.vault.azure.net/"),
 * 					KeyVersion:       pulumi.String("9f85549d7bf14ff4bf178c10d3bdca95"),
 * 				},
 * 				State: pulumi.String("Enabled"),
 * 			},
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cognitiveservices.EncryptionScope;
 * import com.pulumi.azurenative.cognitiveservices.EncryptionScopeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var encryptionScope = new EncryptionScope("encryptionScope", EncryptionScopeArgs.builder()
 *             .accountName("accountName")
 *             .encryptionScopeName("encryptionScopeName")
 *             .properties(Map.ofEntries(
 *                 Map.entry("keySource", "Microsoft.KeyVault"),
 *                 Map.entry("keyVaultProperties", Map.ofEntries(
 *                     Map.entry("identityClientId", "00000000-0000-0000-0000-000000000000"),
 *                     Map.entry("keyName", "DevKeyWestUS2"),
 *                     Map.entry("keyVaultUri", "https://devkvwestus2.vault.azure.net/"),
 *                     Map.entry("keyVersion", "9f85549d7bf14ff4bf178c10d3bdca95")
 *                 )),
 *                 Map.entry("state", "Enabled")
 *             ))
 *             .resourceGroupName("resourceGroupName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cognitiveservices:EncryptionScope encryptionScopeName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CognitiveServices/accounts/{accountName}/encryptionScopes/{encryptionScopeName}
 * ```
 * @property accountName The name of Cognitive Services account.
 * @property encryptionScopeName The name of the encryptionScope associated with the Cognitive Services Account
 * @property properties Properties of Cognitive Services EncryptionScope.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class EncryptionScopeArgs(
    public val accountName: Output<String>? = null,
    public val encryptionScopeName: Output<String>? = null,
    public val properties: Output<EncryptionScopePropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cognitiveservices.EncryptionScopeArgs> {
    override fun toJava(): com.pulumi.azurenative.cognitiveservices.EncryptionScopeArgs =
        com.pulumi.azurenative.cognitiveservices.EncryptionScopeArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .encryptionScopeName(encryptionScopeName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [EncryptionScopeArgs].
 */
@PulumiTagMarker
public class EncryptionScopeArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var encryptionScopeName: Output<String>? = null

    private var properties: Output<EncryptionScopePropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of Cognitive Services account.
     */
    @JvmName("efkftihjvgsafpvh")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The name of the encryptionScope associated with the Cognitive Services Account
     */
    @JvmName("ccgpvruflakdxiek")
    public suspend fun encryptionScopeName(`value`: Output<String>) {
        this.encryptionScopeName = value
    }

    /**
     * @param value Properties of Cognitive Services EncryptionScope.
     */
    @JvmName("tmqphptibqpawbyo")
    public suspend fun properties(`value`: Output<EncryptionScopePropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ratgdjfplktcrsbb")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("wqlihqwrldcuipte")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of Cognitive Services account.
     */
    @JvmName("gdnejbrbkcagoars")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The name of the encryptionScope associated with the Cognitive Services Account
     */
    @JvmName("fhnpdymuwtjuctht")
    public suspend fun encryptionScopeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionScopeName = mapped
    }

    /**
     * @param value Properties of Cognitive Services EncryptionScope.
     */
    @JvmName("pmsoyqgmvwyhnjap")
    public suspend fun properties(`value`: EncryptionScopePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of Cognitive Services EncryptionScope.
     */
    @JvmName("siisqfgdyxorbnwh")
    public suspend fun properties(argument: suspend EncryptionScopePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = EncryptionScopePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kmymarkanwyyfxig")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("enosrfmbffiutvap")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("lymfcuxwfnwycmsx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): EncryptionScopeArgs = EncryptionScopeArgs(
        accountName = accountName,
        encryptionScopeName = encryptionScopeName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
