@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin.inputs

import com.pulumi.azurenative.cognitiveservices.inputs.ApiPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The api properties for special APIs.
 * @property aadClientId (Metrics Advisor Only) The Azure AD Client Id (Application Id).
 * @property aadTenantId (Metrics Advisor Only) The Azure AD Tenant Id.
 * @property eventHubConnectionString (Personalization Only) The flag to enable statistics of Bing Search.
 * @property qnaAzureSearchEndpointId (QnAMaker Only) The Azure Search endpoint id of QnAMaker.
 * @property qnaAzureSearchEndpointKey (QnAMaker Only) The Azure Search endpoint key of QnAMaker.
 * @property qnaRuntimeEndpoint (QnAMaker Only) The runtime endpoint of QnAMaker.
 * @property statisticsEnabled (Bing Search Only) The flag to enable statistics of Bing Search.
 * @property storageAccountConnectionString (Personalization Only) The storage account connection string.
 * @property superUser (Metrics Advisor Only) The super user of Metrics Advisor.
 * @property websiteName (Metrics Advisor Only) The website name of Metrics Advisor.
 */
public data class ApiPropertiesArgs(
    public val aadClientId: Output<String>? = null,
    public val aadTenantId: Output<String>? = null,
    public val eventHubConnectionString: Output<String>? = null,
    public val qnaAzureSearchEndpointId: Output<String>? = null,
    public val qnaAzureSearchEndpointKey: Output<String>? = null,
    public val qnaRuntimeEndpoint: Output<String>? = null,
    public val statisticsEnabled: Output<Boolean>? = null,
    public val storageAccountConnectionString: Output<String>? = null,
    public val superUser: Output<String>? = null,
    public val websiteName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cognitiveservices.inputs.ApiPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.cognitiveservices.inputs.ApiPropertiesArgs =
        com.pulumi.azurenative.cognitiveservices.inputs.ApiPropertiesArgs.builder()
            .aadClientId(aadClientId?.applyValue({ args0 -> args0 }))
            .aadTenantId(aadTenantId?.applyValue({ args0 -> args0 }))
            .eventHubConnectionString(eventHubConnectionString?.applyValue({ args0 -> args0 }))
            .qnaAzureSearchEndpointId(qnaAzureSearchEndpointId?.applyValue({ args0 -> args0 }))
            .qnaAzureSearchEndpointKey(qnaAzureSearchEndpointKey?.applyValue({ args0 -> args0 }))
            .qnaRuntimeEndpoint(qnaRuntimeEndpoint?.applyValue({ args0 -> args0 }))
            .statisticsEnabled(statisticsEnabled?.applyValue({ args0 -> args0 }))
            .storageAccountConnectionString(storageAccountConnectionString?.applyValue({ args0 -> args0 }))
            .superUser(superUser?.applyValue({ args0 -> args0 }))
            .websiteName(websiteName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApiPropertiesArgs].
 */
@PulumiTagMarker
public class ApiPropertiesArgsBuilder internal constructor() {
    private var aadClientId: Output<String>? = null

    private var aadTenantId: Output<String>? = null

    private var eventHubConnectionString: Output<String>? = null

    private var qnaAzureSearchEndpointId: Output<String>? = null

    private var qnaAzureSearchEndpointKey: Output<String>? = null

    private var qnaRuntimeEndpoint: Output<String>? = null

    private var statisticsEnabled: Output<Boolean>? = null

    private var storageAccountConnectionString: Output<String>? = null

    private var superUser: Output<String>? = null

    private var websiteName: Output<String>? = null

    /**
     * @param value (Metrics Advisor Only) The Azure AD Client Id (Application Id).
     */
    @JvmName("ntwhvdyilqafnlyc")
    public suspend fun aadClientId(`value`: Output<String>) {
        this.aadClientId = value
    }

    /**
     * @param value (Metrics Advisor Only) The Azure AD Tenant Id.
     */
    @JvmName("inqmoodtevnkfalp")
    public suspend fun aadTenantId(`value`: Output<String>) {
        this.aadTenantId = value
    }

    /**
     * @param value (Personalization Only) The flag to enable statistics of Bing Search.
     */
    @JvmName("inagwmkbnmvhpcwd")
    public suspend fun eventHubConnectionString(`value`: Output<String>) {
        this.eventHubConnectionString = value
    }

    /**
     * @param value (QnAMaker Only) The Azure Search endpoint id of QnAMaker.
     */
    @JvmName("qhttyojjfpljkgke")
    public suspend fun qnaAzureSearchEndpointId(`value`: Output<String>) {
        this.qnaAzureSearchEndpointId = value
    }

    /**
     * @param value (QnAMaker Only) The Azure Search endpoint key of QnAMaker.
     */
    @JvmName("xklkjbcvljllrdvi")
    public suspend fun qnaAzureSearchEndpointKey(`value`: Output<String>) {
        this.qnaAzureSearchEndpointKey = value
    }

    /**
     * @param value (QnAMaker Only) The runtime endpoint of QnAMaker.
     */
    @JvmName("uhifpxbxlkwtghow")
    public suspend fun qnaRuntimeEndpoint(`value`: Output<String>) {
        this.qnaRuntimeEndpoint = value
    }

    /**
     * @param value (Bing Search Only) The flag to enable statistics of Bing Search.
     */
    @JvmName("noaqbapebnjcbxfa")
    public suspend fun statisticsEnabled(`value`: Output<Boolean>) {
        this.statisticsEnabled = value
    }

    /**
     * @param value (Personalization Only) The storage account connection string.
     */
    @JvmName("luogbtiwfthlfmfs")
    public suspend fun storageAccountConnectionString(`value`: Output<String>) {
        this.storageAccountConnectionString = value
    }

    /**
     * @param value (Metrics Advisor Only) The super user of Metrics Advisor.
     */
    @JvmName("wmxbbuuujmsvokgo")
    public suspend fun superUser(`value`: Output<String>) {
        this.superUser = value
    }

    /**
     * @param value (Metrics Advisor Only) The website name of Metrics Advisor.
     */
    @JvmName("xnmkmplentkbtrlv")
    public suspend fun websiteName(`value`: Output<String>) {
        this.websiteName = value
    }

    /**
     * @param value (Metrics Advisor Only) The Azure AD Client Id (Application Id).
     */
    @JvmName("tdyjxkoxbhonflht")
    public suspend fun aadClientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aadClientId = mapped
    }

    /**
     * @param value (Metrics Advisor Only) The Azure AD Tenant Id.
     */
    @JvmName("peddlvgeillpdbgo")
    public suspend fun aadTenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aadTenantId = mapped
    }

    /**
     * @param value (Personalization Only) The flag to enable statistics of Bing Search.
     */
    @JvmName("hwejccjkhcdbjsdc")
    public suspend fun eventHubConnectionString(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventHubConnectionString = mapped
    }

    /**
     * @param value (QnAMaker Only) The Azure Search endpoint id of QnAMaker.
     */
    @JvmName("hfwfxeljmwmljroe")
    public suspend fun qnaAzureSearchEndpointId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.qnaAzureSearchEndpointId = mapped
    }

    /**
     * @param value (QnAMaker Only) The Azure Search endpoint key of QnAMaker.
     */
    @JvmName("wceewatjuugvraar")
    public suspend fun qnaAzureSearchEndpointKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.qnaAzureSearchEndpointKey = mapped
    }

    /**
     * @param value (QnAMaker Only) The runtime endpoint of QnAMaker.
     */
    @JvmName("pmvbboacukbxrtqs")
    public suspend fun qnaRuntimeEndpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.qnaRuntimeEndpoint = mapped
    }

    /**
     * @param value (Bing Search Only) The flag to enable statistics of Bing Search.
     */
    @JvmName("txkwchojhuhwywwj")
    public suspend fun statisticsEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.statisticsEnabled = mapped
    }

    /**
     * @param value (Personalization Only) The storage account connection string.
     */
    @JvmName("cuusgwfgfjnlfpfd")
    public suspend fun storageAccountConnectionString(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountConnectionString = mapped
    }

    /**
     * @param value (Metrics Advisor Only) The super user of Metrics Advisor.
     */
    @JvmName("yhmqyfopmdjqvxda")
    public suspend fun superUser(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.superUser = mapped
    }

    /**
     * @param value (Metrics Advisor Only) The website name of Metrics Advisor.
     */
    @JvmName("whvwbyybehfplmko")
    public suspend fun websiteName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.websiteName = mapped
    }

    internal fun build(): ApiPropertiesArgs = ApiPropertiesArgs(
        aadClientId = aadClientId,
        aadTenantId = aadTenantId,
        eventHubConnectionString = eventHubConnectionString,
        qnaAzureSearchEndpointId = qnaAzureSearchEndpointId,
        qnaAzureSearchEndpointKey = qnaAzureSearchEndpointKey,
        qnaRuntimeEndpoint = qnaRuntimeEndpoint,
        statisticsEnabled = statisticsEnabled,
        storageAccountConnectionString = storageAccountConnectionString,
        superUser = superUser,
        websiteName = websiteName,
    )
}
