@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin.inputs

import com.pulumi.azurenative.cognitiveservices.inputs.DeploymentPropertiesArgs.builder
import com.pulumi.azurenative.cognitiveservices.kotlin.enums.DeploymentModelVersionUpgradeOption
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Properties of Cognitive Services account deployment.
 * @property model Properties of Cognitive Services account deployment model.
 * @property raiPolicyName The name of RAI policy.
 * @property scaleSettings Properties of Cognitive Services account deployment model.
 * @property versionUpgradeOption Deployment model version upgrade option.
 */
public data class DeploymentPropertiesArgs(
    public val model: Output<DeploymentModelArgs>? = null,
    public val raiPolicyName: Output<String>? = null,
    public val scaleSettings: Output<DeploymentScaleSettingsArgs>? = null,
    public val versionUpgradeOption: Output<Either<String, DeploymentModelVersionUpgradeOption>>? =
        null,
) : ConvertibleToJava<com.pulumi.azurenative.cognitiveservices.inputs.DeploymentPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.cognitiveservices.inputs.DeploymentPropertiesArgs =
        com.pulumi.azurenative.cognitiveservices.inputs.DeploymentPropertiesArgs.builder()
            .model(model?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .raiPolicyName(raiPolicyName?.applyValue({ args0 -> args0 }))
            .scaleSettings(scaleSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .versionUpgradeOption(
                versionUpgradeOption?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [DeploymentPropertiesArgs].
 */
@PulumiTagMarker
public class DeploymentPropertiesArgsBuilder internal constructor() {
    private var model: Output<DeploymentModelArgs>? = null

    private var raiPolicyName: Output<String>? = null

    private var scaleSettings: Output<DeploymentScaleSettingsArgs>? = null

    private var versionUpgradeOption: Output<Either<String, DeploymentModelVersionUpgradeOption>>? =
        null

    /**
     * @param value Properties of Cognitive Services account deployment model.
     */
    @JvmName("ijgabkmflfmtyfhp")
    public suspend fun model(`value`: Output<DeploymentModelArgs>) {
        this.model = value
    }

    /**
     * @param value The name of RAI policy.
     */
    @JvmName("cpcguevubtrvwcyj")
    public suspend fun raiPolicyName(`value`: Output<String>) {
        this.raiPolicyName = value
    }

    /**
     * @param value Properties of Cognitive Services account deployment model.
     */
    @JvmName("drljsphwnpdyqrgg")
    public suspend fun scaleSettings(`value`: Output<DeploymentScaleSettingsArgs>) {
        this.scaleSettings = value
    }

    /**
     * @param value Deployment model version upgrade option.
     */
    @JvmName("yxsdogsynekbqjhd")
    public suspend
    fun versionUpgradeOption(`value`: Output<Either<String, DeploymentModelVersionUpgradeOption>>) {
        this.versionUpgradeOption = value
    }

    /**
     * @param value Properties of Cognitive Services account deployment model.
     */
    @JvmName("lvyiddqvdtypofnu")
    public suspend fun model(`value`: DeploymentModelArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.model = mapped
    }

    /**
     * @param argument Properties of Cognitive Services account deployment model.
     */
    @JvmName("iauiprecirpplvny")
    public suspend fun model(argument: suspend DeploymentModelArgsBuilder.() -> Unit) {
        val toBeMapped = DeploymentModelArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.model = mapped
    }

    /**
     * @param value The name of RAI policy.
     */
    @JvmName("udatjnjinrcmqqji")
    public suspend fun raiPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.raiPolicyName = mapped
    }

    /**
     * @param value Properties of Cognitive Services account deployment model.
     */
    @JvmName("alacrfcdkvwdtgva")
    public suspend fun scaleSettings(`value`: DeploymentScaleSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scaleSettings = mapped
    }

    /**
     * @param argument Properties of Cognitive Services account deployment model.
     */
    @JvmName("lsshgkalduugqhgm")
    public suspend
    fun scaleSettings(argument: suspend DeploymentScaleSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = DeploymentScaleSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.scaleSettings = mapped
    }

    /**
     * @param value Deployment model version upgrade option.
     */
    @JvmName("jpyxacyudvcilqwg")
    public suspend
    fun versionUpgradeOption(`value`: Either<String, DeploymentModelVersionUpgradeOption>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.versionUpgradeOption = mapped
    }

    /**
     * @param value Deployment model version upgrade option.
     */
    @JvmName("dvnyocaiojrvgqpw")
    public fun versionUpgradeOption(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DeploymentModelVersionUpgradeOption>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.versionUpgradeOption = mapped
    }

    /**
     * @param value Deployment model version upgrade option.
     */
    @JvmName("ytdoxtykpcussvng")
    public fun versionUpgradeOption(`value`: DeploymentModelVersionUpgradeOption) {
        val toBeMapped = Either.ofRight<String, DeploymentModelVersionUpgradeOption>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.versionUpgradeOption = mapped
    }

    internal fun build(): DeploymentPropertiesArgs = DeploymentPropertiesArgs(
        model = model,
        raiPolicyName = raiPolicyName,
        scaleSettings = scaleSettings,
        versionUpgradeOption = versionUpgradeOption,
    )
}
