@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin.inputs

import com.pulumi.azurenative.cognitiveservices.inputs.DeploymentScaleSettingsArgs.builder
import com.pulumi.azurenative.cognitiveservices.kotlin.enums.DeploymentScaleType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties of Cognitive Services account deployment model.
 * @property capacity Deployment capacity.
 * @property scaleType Deployment scale type.
 */
public data class DeploymentScaleSettingsArgs(
    public val capacity: Output<Int>? = null,
    public val scaleType: Output<Either<String, DeploymentScaleType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cognitiveservices.inputs.DeploymentScaleSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.cognitiveservices.inputs.DeploymentScaleSettingsArgs =
        com.pulumi.azurenative.cognitiveservices.inputs.DeploymentScaleSettingsArgs.builder()
            .capacity(capacity?.applyValue({ args0 -> args0 }))
            .scaleType(
                scaleType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [DeploymentScaleSettingsArgs].
 */
@PulumiTagMarker
public class DeploymentScaleSettingsArgsBuilder internal constructor() {
    private var capacity: Output<Int>? = null

    private var scaleType: Output<Either<String, DeploymentScaleType>>? = null

    /**
     * @param value Deployment capacity.
     */
    @JvmName("vbqraoprsjddorug")
    public suspend fun capacity(`value`: Output<Int>) {
        this.capacity = value
    }

    /**
     * @param value Deployment scale type.
     */
    @JvmName("bkhienqxdnesdnmk")
    public suspend fun scaleType(`value`: Output<Either<String, DeploymentScaleType>>) {
        this.scaleType = value
    }

    /**
     * @param value Deployment capacity.
     */
    @JvmName("tdylefbqtfdasxkf")
    public suspend fun capacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacity = mapped
    }

    /**
     * @param value Deployment scale type.
     */
    @JvmName("oiporlrsbqphlbpf")
    public suspend fun scaleType(`value`: Either<String, DeploymentScaleType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scaleType = mapped
    }

    /**
     * @param value Deployment scale type.
     */
    @JvmName("xuodnfspmcowkgke")
    public fun scaleType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DeploymentScaleType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scaleType = mapped
    }

    /**
     * @param value Deployment scale type.
     */
    @JvmName("xnkgioathfumnjeq")
    public fun scaleType(`value`: DeploymentScaleType) {
        val toBeMapped = Either.ofRight<String, DeploymentScaleType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scaleType = mapped
    }

    internal fun build(): DeploymentScaleSettingsArgs = DeploymentScaleSettingsArgs(
        capacity = capacity,
        scaleType = scaleType,
    )
}
