@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin.inputs

import com.pulumi.azurenative.cognitiveservices.inputs.GetRaiBlocklistPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of Cognitive Services account.
 * @property raiBlocklistName The name of the RaiBlocklist associated with the Cognitive Services Account
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetRaiBlocklistPlainArgs(
    public val accountName: String,
    public val raiBlocklistName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.cognitiveservices.inputs.GetRaiBlocklistPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.cognitiveservices.inputs.GetRaiBlocklistPlainArgs =
        com.pulumi.azurenative.cognitiveservices.inputs.GetRaiBlocklistPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .raiBlocklistName(raiBlocklistName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRaiBlocklistPlainArgs].
 */
@PulumiTagMarker
public class GetRaiBlocklistPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var raiBlocklistName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of Cognitive Services account.
     */
    @JvmName("gjurapxxxucoyfmk")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The name of the RaiBlocklist associated with the Cognitive Services Account
     */
    @JvmName("qcebnxdklinyfrfe")
    public suspend fun raiBlocklistName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.raiBlocklistName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hvqoxymdybytixvh")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetRaiBlocklistPlainArgs = GetRaiBlocklistPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        raiBlocklistName = raiBlocklistName ?: throw PulumiNullFieldException("raiBlocklistName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
