@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin.inputs

import com.pulumi.azurenative.cognitiveservices.inputs.GetRaiPolicyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of Cognitive Services account.
 * @property raiPolicyName The name of the RaiPolicy associated with the Cognitive Services Account
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetRaiPolicyPlainArgs(
    public val accountName: String,
    public val raiPolicyName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.cognitiveservices.inputs.GetRaiPolicyPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.cognitiveservices.inputs.GetRaiPolicyPlainArgs =
        com.pulumi.azurenative.cognitiveservices.inputs.GetRaiPolicyPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .raiPolicyName(raiPolicyName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRaiPolicyPlainArgs].
 */
@PulumiTagMarker
public class GetRaiPolicyPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var raiPolicyName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of Cognitive Services account.
     */
    @JvmName("keayldaundgwaomp")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The name of the RaiPolicy associated with the Cognitive Services Account
     */
    @JvmName("cxfsqbdyqmjsqges")
    public suspend fun raiPolicyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.raiPolicyName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("unlyxpurykfegpyt")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetRaiPolicyPlainArgs = GetRaiPolicyPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        raiPolicyName = raiPolicyName ?: throw PulumiNullFieldException("raiPolicyName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
