@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin.inputs

import com.pulumi.azurenative.cognitiveservices.inputs.KeyVaultPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties to configure keyVault Properties
 * @property identityClientId
 * @property keyName Name of the Key from KeyVault
 * @property keyVaultUri Uri of KeyVault
 * @property keyVersion Version of the Key from KeyVault
 */
public data class KeyVaultPropertiesArgs(
    public val identityClientId: Output<String>? = null,
    public val keyName: Output<String>? = null,
    public val keyVaultUri: Output<String>? = null,
    public val keyVersion: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cognitiveservices.inputs.KeyVaultPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.cognitiveservices.inputs.KeyVaultPropertiesArgs =
        com.pulumi.azurenative.cognitiveservices.inputs.KeyVaultPropertiesArgs.builder()
            .identityClientId(identityClientId?.applyValue({ args0 -> args0 }))
            .keyName(keyName?.applyValue({ args0 -> args0 }))
            .keyVaultUri(keyVaultUri?.applyValue({ args0 -> args0 }))
            .keyVersion(keyVersion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KeyVaultPropertiesArgs].
 */
@PulumiTagMarker
public class KeyVaultPropertiesArgsBuilder internal constructor() {
    private var identityClientId: Output<String>? = null

    private var keyName: Output<String>? = null

    private var keyVaultUri: Output<String>? = null

    private var keyVersion: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("jspfoanluivlyeyk")
    public suspend fun identityClientId(`value`: Output<String>) {
        this.identityClientId = value
    }

    /**
     * @param value Name of the Key from KeyVault
     */
    @JvmName("nhibhqlnjmhgdvjo")
    public suspend fun keyName(`value`: Output<String>) {
        this.keyName = value
    }

    /**
     * @param value Uri of KeyVault
     */
    @JvmName("wydclefhgwtofqev")
    public suspend fun keyVaultUri(`value`: Output<String>) {
        this.keyVaultUri = value
    }

    /**
     * @param value Version of the Key from KeyVault
     */
    @JvmName("odyerldwtbbcmokc")
    public suspend fun keyVersion(`value`: Output<String>) {
        this.keyVersion = value
    }

    /**
     * @param value
     */
    @JvmName("ehuaaxnehjeropey")
    public suspend fun identityClientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identityClientId = mapped
    }

    /**
     * @param value Name of the Key from KeyVault
     */
    @JvmName("iyxuhljsagtrjdsb")
    public suspend fun keyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyName = mapped
    }

    /**
     * @param value Uri of KeyVault
     */
    @JvmName("qxudxsllkdanvfaq")
    public suspend fun keyVaultUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultUri = mapped
    }

    /**
     * @param value Version of the Key from KeyVault
     */
    @JvmName("aqihdbvrlbgsjiyg")
    public suspend fun keyVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVersion = mapped
    }

    internal fun build(): KeyVaultPropertiesArgs = KeyVaultPropertiesArgs(
        identityClientId = identityClientId,
        keyName = keyName,
        keyVaultUri = keyVaultUri,
        keyVersion = keyVersion,
    )
}
