@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin.inputs

import com.pulumi.azurenative.cognitiveservices.inputs.RaiPolicyContentFilterArgs.builder
import com.pulumi.azurenative.cognitiveservices.kotlin.enums.AllowedContentLevel
import com.pulumi.azurenative.cognitiveservices.kotlin.enums.RaiPolicyContentSource
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Azure OpenAI Content Filter.
 * @property allowedContentLevel Level at which content is filtered.
 * @property blocking If blocking would occur.
 * @property enabled If the ContentFilter is enabled.
 * @property name Name of ContentFilter.
 * @property source Content source to apply the Content Filters.
 */
public data class RaiPolicyContentFilterArgs(
    public val allowedContentLevel: Output<Either<String, AllowedContentLevel>>? = null,
    public val blocking: Output<Boolean>? = null,
    public val enabled: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val source: Output<Either<String, RaiPolicyContentSource>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cognitiveservices.inputs.RaiPolicyContentFilterArgs> {
    override fun toJava(): com.pulumi.azurenative.cognitiveservices.inputs.RaiPolicyContentFilterArgs =
        com.pulumi.azurenative.cognitiveservices.inputs.RaiPolicyContentFilterArgs.builder()
            .allowedContentLevel(
                allowedContentLevel?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .blocking(blocking?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .source(
                source?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [RaiPolicyContentFilterArgs].
 */
@PulumiTagMarker
public class RaiPolicyContentFilterArgsBuilder internal constructor() {
    private var allowedContentLevel: Output<Either<String, AllowedContentLevel>>? = null

    private var blocking: Output<Boolean>? = null

    private var enabled: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var source: Output<Either<String, RaiPolicyContentSource>>? = null

    /**
     * @param value Level at which content is filtered.
     */
    @JvmName("bijuloeutitojghe")
    public suspend fun allowedContentLevel(`value`: Output<Either<String, AllowedContentLevel>>) {
        this.allowedContentLevel = value
    }

    /**
     * @param value If blocking would occur.
     */
    @JvmName("bgldvgdgwyyboojf")
    public suspend fun blocking(`value`: Output<Boolean>) {
        this.blocking = value
    }

    /**
     * @param value If the ContentFilter is enabled.
     */
    @JvmName("gplhgsyprjbchuwi")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Name of ContentFilter.
     */
    @JvmName("puspnhhvctwavtdm")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Content source to apply the Content Filters.
     */
    @JvmName("amybxcmteeljxiem")
    public suspend fun source(`value`: Output<Either<String, RaiPolicyContentSource>>) {
        this.source = value
    }

    /**
     * @param value Level at which content is filtered.
     */
    @JvmName("iolvybtbynmjajal")
    public suspend fun allowedContentLevel(`value`: Either<String, AllowedContentLevel>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedContentLevel = mapped
    }

    /**
     * @param value Level at which content is filtered.
     */
    @JvmName("worlahnxrqjsurgi")
    public fun allowedContentLevel(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AllowedContentLevel>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedContentLevel = mapped
    }

    /**
     * @param value Level at which content is filtered.
     */
    @JvmName("pnmmojnktotsokyw")
    public fun allowedContentLevel(`value`: AllowedContentLevel) {
        val toBeMapped = Either.ofRight<String, AllowedContentLevel>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedContentLevel = mapped
    }

    /**
     * @param value If blocking would occur.
     */
    @JvmName("gytsnmnpeyrxjnvc")
    public suspend fun blocking(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blocking = mapped
    }

    /**
     * @param value If the ContentFilter is enabled.
     */
    @JvmName("mkogqbawnvsxmrha")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Name of ContentFilter.
     */
    @JvmName("nmylspctxehhramb")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Content source to apply the Content Filters.
     */
    @JvmName("pbvatrkifitorgwg")
    public suspend fun source(`value`: Either<String, RaiPolicyContentSource>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param value Content source to apply the Content Filters.
     */
    @JvmName("bxsjmsgogrouowsa")
    public fun source(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RaiPolicyContentSource>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param value Content source to apply the Content Filters.
     */
    @JvmName("wdsujgjqgbvyaeed")
    public fun source(`value`: RaiPolicyContentSource) {
        val toBeMapped = Either.ofRight<String, RaiPolicyContentSource>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.source = mapped
    }

    internal fun build(): RaiPolicyContentFilterArgs = RaiPolicyContentFilterArgs(
        allowedContentLevel = allowedContentLevel,
        blocking = blocking,
        enabled = enabled,
        name = name,
        source = source,
    )
}
