@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin.inputs

import com.pulumi.azurenative.cognitiveservices.inputs.RegionSettingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The call rate limit Cognitive Services account.
 * @property customsubdomain Maps the region to the regional custom subdomain.
 * @property name Name of the region.
 * @property value A value for priority or weighted routing methods.
 */
public data class RegionSettingArgs(
    public val customsubdomain: Output<String>? = null,
    public val name: Output<String>? = null,
    public val `value`: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cognitiveservices.inputs.RegionSettingArgs> {
    override fun toJava(): com.pulumi.azurenative.cognitiveservices.inputs.RegionSettingArgs =
        com.pulumi.azurenative.cognitiveservices.inputs.RegionSettingArgs.builder()
            .customsubdomain(customsubdomain?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RegionSettingArgs].
 */
@PulumiTagMarker
public class RegionSettingArgsBuilder internal constructor() {
    private var customsubdomain: Output<String>? = null

    private var name: Output<String>? = null

    private var `value`: Output<Double>? = null

    /**
     * @param value Maps the region to the regional custom subdomain.
     */
    @JvmName("idelxikqyldlxlkt")
    public suspend fun customsubdomain(`value`: Output<String>) {
        this.customsubdomain = value
    }

    /**
     * @param value Name of the region.
     */
    @JvmName("dpycucjpirwcfymi")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A value for priority or weighted routing methods.
     */
    @JvmName("mgbdcjmlbjeemcwu")
    public suspend fun `value`(`value`: Output<Double>) {
        this.`value` = value
    }

    /**
     * @param value Maps the region to the regional custom subdomain.
     */
    @JvmName("pmjyrbunstnqruyu")
    public suspend fun customsubdomain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customsubdomain = mapped
    }

    /**
     * @param value Name of the region.
     */
    @JvmName("ysjdwsymfuqghemy")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A value for priority or weighted routing methods.
     */
    @JvmName("wcilulogutbhjibt")
    public suspend fun `value`(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): RegionSettingArgs = RegionSettingArgs(
        customsubdomain = customsubdomain,
        name = name,
        `value` = `value`,
    )
}
