@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Properties of Cognitive Services account deployment.
 * @property callRateLimit The call rate limit Cognitive Services account.
 * @property capabilities The capabilities.
 * @property model Properties of Cognitive Services account deployment model.
 * @property provisioningState Gets the status of the resource at the time the operation was called.
 * @property raiPolicyName The name of RAI policy.
 * @property rateLimits
 * @property scaleSettings Properties of Cognitive Services account deployment model.
 * @property versionUpgradeOption Deployment model version upgrade option.
 */
public data class DeploymentPropertiesResponse(
    public val callRateLimit: CallRateLimitResponse,
    public val capabilities: Map<String, String>,
    public val model: DeploymentModelResponse? = null,
    public val provisioningState: String,
    public val raiPolicyName: String? = null,
    public val rateLimits: List<ThrottlingRuleResponse>,
    public val scaleSettings: DeploymentScaleSettingsResponse? = null,
    public val versionUpgradeOption: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.cognitiveservices.outputs.DeploymentPropertiesResponse):
            DeploymentPropertiesResponse = DeploymentPropertiesResponse(
            callRateLimit = javaType.callRateLimit().let({ args0 ->
                com.pulumi.azurenative.cognitiveservices.kotlin.outputs.CallRateLimitResponse.Companion.toKotlin(args0)
            }),
            capabilities = javaType.capabilities().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            model = javaType.model().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cognitiveservices.kotlin.outputs.DeploymentModelResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            raiPolicyName = javaType.raiPolicyName().map({ args0 -> args0 }).orElse(null),
            rateLimits = javaType.rateLimits().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cognitiveservices.kotlin.outputs.ThrottlingRuleResponse.Companion.toKotlin(args0)
                })
            }),
            scaleSettings = javaType.scaleSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cognitiveservices.kotlin.outputs.DeploymentScaleSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            versionUpgradeOption = javaType.versionUpgradeOption().map({ args0 -> args0 }).orElse(null),
        )
    }
}
