@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Properties to configure keyVault Properties
 * @property identityClientId
 * @property keyName Name of the Key from KeyVault
 * @property keyVaultUri Uri of KeyVault
 * @property keyVersion Version of the Key from KeyVault
 */
public data class KeyVaultPropertiesResponse(
    public val identityClientId: String? = null,
    public val keyName: String? = null,
    public val keyVaultUri: String? = null,
    public val keyVersion: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.cognitiveservices.outputs.KeyVaultPropertiesResponse):
            KeyVaultPropertiesResponse = KeyVaultPropertiesResponse(
            identityClientId = javaType.identityClientId().map({ args0 -> args0 }).orElse(null),
            keyName = javaType.keyName().map({ args0 -> args0 }).orElse(null),
            keyVaultUri = javaType.keyVaultUri().map({ args0 -> args0 }).orElse(null),
            keyVersion = javaType.keyVersion().map({ args0 -> args0 }).orElse(null),
        )
    }
}
