@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Properties of the PrivateEndpointConnectProperties.
 * @property groupIds The private link resource group ids.
 * @property privateEndpoint The resource of private end point.
 * @property privateLinkServiceConnectionState A collection of information about the state of the connection between service consumer and provider.
 * @property provisioningState The provisioning state of the private endpoint connection resource.
 */
public data class PrivateEndpointConnectionPropertiesResponse(
    public val groupIds: List<String>? = null,
    public val privateEndpoint: PrivateEndpointResponse? = null,
    public val privateLinkServiceConnectionState: PrivateLinkServiceConnectionStateResponse,
    public val provisioningState: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.cognitiveservices.outputs.PrivateEndpointConnectionPropertiesResponse):
            PrivateEndpointConnectionPropertiesResponse = PrivateEndpointConnectionPropertiesResponse(
            groupIds = javaType.groupIds().map({ args0 -> args0 }),
            privateEndpoint = javaType.privateEndpoint().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cognitiveservices.kotlin.outputs.PrivateEndpointResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            privateLinkServiceConnectionState = javaType.privateLinkServiceConnectionState().let({ args0 ->
                com.pulumi.azurenative.cognitiveservices.kotlin.outputs.PrivateLinkServiceConnectionStateResponse.Companion.toKotlin(args0)
            }),
            provisioningState = javaType.provisioningState(),
        )
    }
}
