@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.communication.kotlin

import com.pulumi.azurenative.communication.SuppressionListAddressArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A object that represents a SuppressionList record.
 * Azure REST API version: 2023-06-01-preview.
 * ## Example Usage
 * ### CreateOrUpdate SuppressionListAddress resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var suppressionListAddress = new AzureNative.Communication.SuppressionListAddress("suppressionListAddress", new()
 *     {
 *         AddressId = "11112222-3333-4444-5555-aaaabbbbcccc",
 *         DomainName = "contoso.com",
 *         Email = "newuser1@fabrikam.com",
 *         EmailServiceName = "contosoEmailService",
 *         FirstName = "updatedFirstName",
 *         ResourceGroupName = "contosoResourceGroup",
 *         SuppressionListName = "aaaa1111-bbbb-2222-3333-aaaa11112222",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/communication/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := communication.NewSuppressionListAddress(ctx, "suppressionListAddress", &communication.SuppressionListAddressArgs{
 * 			AddressId:           pulumi.String("11112222-3333-4444-5555-aaaabbbbcccc"),
 * 			DomainName:          pulumi.String("contoso.com"),
 * 			Email:               pulumi.String("newuser1@fabrikam.com"),
 * 			EmailServiceName:    pulumi.String("contosoEmailService"),
 * 			FirstName:           pulumi.String("updatedFirstName"),
 * 			ResourceGroupName:   pulumi.String("contosoResourceGroup"),
 * 			SuppressionListName: pulumi.String("aaaa1111-bbbb-2222-3333-aaaa11112222"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.communication.SuppressionListAddress;
 * import com.pulumi.azurenative.communication.SuppressionListAddressArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var suppressionListAddress = new SuppressionListAddress("suppressionListAddress", SuppressionListAddressArgs.builder()
 *             .addressId("11112222-3333-4444-5555-aaaabbbbcccc")
 *             .domainName("contoso.com")
 *             .email("newuser1@fabrikam.com")
 *             .emailServiceName("contosoEmailService")
 *             .firstName("updatedFirstName")
 *             .resourceGroupName("contosoResourceGroup")
 *             .suppressionListName("aaaa1111-bbbb-2222-3333-aaaa11112222")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:communication:SuppressionListAddress 11112222-3333-4444-5555-aaaabbbbcccc /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Communication/emailServices/{emailServiceName}/domains/{domainName}/suppressionLists/{suppressionListName}/suppressionListAddresses/{addressId}
 * ```
 * @property addressId The id of the address in a suppression list.
 * @property domainName The name of the Domains resource.
 * @property email Email address of the recipient.
 * @property emailServiceName The name of the EmailService resource.
 * @property firstName The first name of the email recipient.
 * @property lastName The last name of the email recipient.
 * @property notes An optional property to provide contextual notes or a description for an address.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property suppressionListName The name of the suppression list.
 */
public data class SuppressionListAddressArgs(
    public val addressId: Output<String>? = null,
    public val domainName: Output<String>? = null,
    public val email: Output<String>? = null,
    public val emailServiceName: Output<String>? = null,
    public val firstName: Output<String>? = null,
    public val lastName: Output<String>? = null,
    public val notes: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val suppressionListName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.communication.SuppressionListAddressArgs> {
    override fun toJava(): com.pulumi.azurenative.communication.SuppressionListAddressArgs =
        com.pulumi.azurenative.communication.SuppressionListAddressArgs.builder()
            .addressId(addressId?.applyValue({ args0 -> args0 }))
            .domainName(domainName?.applyValue({ args0 -> args0 }))
            .email(email?.applyValue({ args0 -> args0 }))
            .emailServiceName(emailServiceName?.applyValue({ args0 -> args0 }))
            .firstName(firstName?.applyValue({ args0 -> args0 }))
            .lastName(lastName?.applyValue({ args0 -> args0 }))
            .notes(notes?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .suppressionListName(suppressionListName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SuppressionListAddressArgs].
 */
@PulumiTagMarker
public class SuppressionListAddressArgsBuilder internal constructor() {
    private var addressId: Output<String>? = null

    private var domainName: Output<String>? = null

    private var email: Output<String>? = null

    private var emailServiceName: Output<String>? = null

    private var firstName: Output<String>? = null

    private var lastName: Output<String>? = null

    private var notes: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var suppressionListName: Output<String>? = null

    /**
     * @param value The id of the address in a suppression list.
     */
    @JvmName("makdmxtpicqoyljo")
    public suspend fun addressId(`value`: Output<String>) {
        this.addressId = value
    }

    /**
     * @param value The name of the Domains resource.
     */
    @JvmName("nrumnbnsftruvxic")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value Email address of the recipient.
     */
    @JvmName("dprbagjiohoiqfta")
    public suspend fun email(`value`: Output<String>) {
        this.email = value
    }

    /**
     * @param value The name of the EmailService resource.
     */
    @JvmName("mdrvrhwcrvmkqpoa")
    public suspend fun emailServiceName(`value`: Output<String>) {
        this.emailServiceName = value
    }

    /**
     * @param value The first name of the email recipient.
     */
    @JvmName("sewmbdauswdcwbxc")
    public suspend fun firstName(`value`: Output<String>) {
        this.firstName = value
    }

    /**
     * @param value The last name of the email recipient.
     */
    @JvmName("qkkknerogkkpmqac")
    public suspend fun lastName(`value`: Output<String>) {
        this.lastName = value
    }

    /**
     * @param value An optional property to provide contextual notes or a description for an address.
     */
    @JvmName("vliehfoxokawlply")
    public suspend fun notes(`value`: Output<String>) {
        this.notes = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lccdbeolryqabgee")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the suppression list.
     */
    @JvmName("ibyptlmluyymmjjb")
    public suspend fun suppressionListName(`value`: Output<String>) {
        this.suppressionListName = value
    }

    /**
     * @param value The id of the address in a suppression list.
     */
    @JvmName("nwpmovgtcilylutt")
    public suspend fun addressId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressId = mapped
    }

    /**
     * @param value The name of the Domains resource.
     */
    @JvmName("wluvtjaqqoebeqyq")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value Email address of the recipient.
     */
    @JvmName("rgddpjipwpppyfqs")
    public suspend fun email(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.email = mapped
    }

    /**
     * @param value The name of the EmailService resource.
     */
    @JvmName("xbxpvgdcegjvlwiw")
    public suspend fun emailServiceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emailServiceName = mapped
    }

    /**
     * @param value The first name of the email recipient.
     */
    @JvmName("fafoghgcidgbrrje")
    public suspend fun firstName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firstName = mapped
    }

    /**
     * @param value The last name of the email recipient.
     */
    @JvmName("uvgqlskceebskiyo")
    public suspend fun lastName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastName = mapped
    }

    /**
     * @param value An optional property to provide contextual notes or a description for an address.
     */
    @JvmName("gnekgpsxbrnxurhs")
    public suspend fun notes(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notes = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ludorbwpyyeldvxn")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the suppression list.
     */
    @JvmName("axiqoqvlxnualmwn")
    public suspend fun suppressionListName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.suppressionListName = mapped
    }

    internal fun build(): SuppressionListAddressArgs = SuppressionListAddressArgs(
        addressId = addressId,
        domainName = domainName,
        email = email,
        emailServiceName = emailServiceName,
        firstName = firstName,
        lastName = lastName,
        notes = notes,
        resourceGroupName = resourceGroupName,
        suppressionListName = suppressionListName,
    )
}
