@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.communication.kotlin

import com.pulumi.azurenative.communication.SuppressionListArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A class representing a SuppressionList resource.
 * Azure REST API version: 2023-06-01-preview.
 * ## Example Usage
 * ### CreateOrUpdate SuppressionLists resource.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var suppressionList = new AzureNative.Communication.SuppressionList("suppressionList", new()
 *     {
 *         DomainName = "contoso.com",
 *         EmailServiceName = "contosoEmailService",
 *         ListName = "contosoNewsAlerts",
 *         ResourceGroupName = "contosoResourceGroup",
 *         SuppressionListName = "aaaa1111-bbbb-2222-3333-aaaa11112222",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/communication/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := communication.NewSuppressionList(ctx, "suppressionList", &communication.SuppressionListArgs{
 * 			DomainName:          pulumi.String("contoso.com"),
 * 			EmailServiceName:    pulumi.String("contosoEmailService"),
 * 			ListName:            pulumi.String("contosoNewsAlerts"),
 * 			ResourceGroupName:   pulumi.String("contosoResourceGroup"),
 * 			SuppressionListName: pulumi.String("aaaa1111-bbbb-2222-3333-aaaa11112222"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.communication.SuppressionList;
 * import com.pulumi.azurenative.communication.SuppressionListArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var suppressionList = new SuppressionList("suppressionList", SuppressionListArgs.builder()
 *             .domainName("contoso.com")
 *             .emailServiceName("contosoEmailService")
 *             .listName("contosoNewsAlerts")
 *             .resourceGroupName("contosoResourceGroup")
 *             .suppressionListName("aaaa1111-bbbb-2222-3333-aaaa11112222")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:communication:SuppressionList aaaa1111-bbbb-2222-3333-aaaa11112222 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Communication/emailServices/{emailServiceName}/domains/{domainName}/suppressionLists/{suppressionListName}
 * ```
 * @property domainName The name of the Domains resource.
 * @property emailServiceName The name of the EmailService resource.
 * @property listName The the name of the suppression list. This value must match one of the valid sender usernames of the sending domain.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property suppressionListName The name of the suppression list.
 */
public data class SuppressionListArgs(
    public val domainName: Output<String>? = null,
    public val emailServiceName: Output<String>? = null,
    public val listName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val suppressionListName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.communication.SuppressionListArgs> {
    override fun toJava(): com.pulumi.azurenative.communication.SuppressionListArgs =
        com.pulumi.azurenative.communication.SuppressionListArgs.builder()
            .domainName(domainName?.applyValue({ args0 -> args0 }))
            .emailServiceName(emailServiceName?.applyValue({ args0 -> args0 }))
            .listName(listName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .suppressionListName(suppressionListName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SuppressionListArgs].
 */
@PulumiTagMarker
public class SuppressionListArgsBuilder internal constructor() {
    private var domainName: Output<String>? = null

    private var emailServiceName: Output<String>? = null

    private var listName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var suppressionListName: Output<String>? = null

    /**
     * @param value The name of the Domains resource.
     */
    @JvmName("lycbeabpwnilfcpf")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value The name of the EmailService resource.
     */
    @JvmName("tuvtdxhsaktslvgx")
    public suspend fun emailServiceName(`value`: Output<String>) {
        this.emailServiceName = value
    }

    /**
     * @param value The the name of the suppression list. This value must match one of the valid sender usernames of the sending domain.
     */
    @JvmName("sabbmsunjofdhthq")
    public suspend fun listName(`value`: Output<String>) {
        this.listName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("owkkscpmcykdqnhi")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the suppression list.
     */
    @JvmName("gkfqkpjxldjydctm")
    public suspend fun suppressionListName(`value`: Output<String>) {
        this.suppressionListName = value
    }

    /**
     * @param value The name of the Domains resource.
     */
    @JvmName("yhepvoyvulrbbjfx")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value The name of the EmailService resource.
     */
    @JvmName("htvbexvuxlybqkip")
    public suspend fun emailServiceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emailServiceName = mapped
    }

    /**
     * @param value The the name of the suppression list. This value must match one of the valid sender usernames of the sending domain.
     */
    @JvmName("yfuaroetnogspdiy")
    public suspend fun listName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.listName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("bmsdpkutywkdoaok")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the suppression list.
     */
    @JvmName("pxhnneikwyorcsqv")
    public suspend fun suppressionListName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.suppressionListName = mapped
    }

    internal fun build(): SuppressionListArgs = SuppressionListArgs(
        domainName = domainName,
        emailServiceName = emailServiceName,
        listName = listName,
        resourceGroupName = resourceGroupName,
        suppressionListName = suppressionListName,
    )
}
