@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.community.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Details of the Community CommunityTraining Identity Configuration
 * @property b2cAuthenticationPolicy The name of the authentication policy registered in ADB2C for the Community Training Resource
 * @property b2cPasswordResetPolicy The name of the password reset policy registered in ADB2C for the Community Training Resource
 * @property clientId The clientId of the application registered in the selected identity provider for the Community Training Resource
 * @property clientSecret The client secret of the application registered in the selected identity provider for the Community Training Resource
 * @property customLoginParameters The custom login parameters for the Community Training Resource
 * @property domainName The domain name of the selected identity provider for the Community Training Resource
 * @property identityType The identity type of the Community Training Resource
 * @property teamsEnabled To indicate whether the Community Training Resource has Teams enabled
 * @property tenantId The tenantId of the selected identity provider for the Community Training Resource
 */
public data class IdentityConfigurationPropertiesResponse(
    public val b2cAuthenticationPolicy: String? = null,
    public val b2cPasswordResetPolicy: String? = null,
    public val clientId: String,
    public val clientSecret: String,
    public val customLoginParameters: String? = null,
    public val domainName: String,
    public val identityType: String,
    public val teamsEnabled: Boolean? = null,
    public val tenantId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.community.outputs.IdentityConfigurationPropertiesResponse):
            IdentityConfigurationPropertiesResponse = IdentityConfigurationPropertiesResponse(
            b2cAuthenticationPolicy = javaType.b2cAuthenticationPolicy().map({ args0 -> args0 }).orElse(null),
            b2cPasswordResetPolicy = javaType.b2cPasswordResetPolicy().map({ args0 -> args0 }).orElse(null),
            clientId = javaType.clientId(),
            clientSecret = javaType.clientSecret(),
            customLoginParameters = javaType.customLoginParameters().map({ args0 -> args0 }).orElse(null),
            domainName = javaType.domainName(),
            identityType = javaType.identityType(),
            teamsEnabled = javaType.teamsEnabled().map({ args0 -> args0 }).orElse(null),
            tenantId = javaType.tenantId(),
        )
    }
}
