@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin

import com.pulumi.azurenative.compute.kotlin.outputs.InstanceViewStatusResponse
import com.pulumi.azurenative.compute.kotlin.outputs.SkuResponse
import com.pulumi.azurenative.compute.kotlin.outputs.SubResourceResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.compute.kotlin.outputs.InstanceViewStatusResponse.Companion.toKotlin as instanceViewStatusResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.SubResourceResponse.Companion.toKotlin as subResourceResponseToKotlin

/**
 * Builder for [AvailabilitySet].
 */
@PulumiTagMarker
public class AvailabilitySetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AvailabilitySetArgs = AvailabilitySetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AvailabilitySetArgsBuilder.() -> Unit) {
        val builder = AvailabilitySetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): AvailabilitySet {
        val builtJavaResource = com.pulumi.azurenative.compute.AvailabilitySet(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AvailabilitySet(builtJavaResource)
    }
}

/**
 * Specifies information about the availability set that the virtual machine should be assigned to. Virtual machines specified in the same availability set are allocated to different nodes to maximize availability. For more information about availability sets, see [Availability sets overview](https://docs&#46;microsoft&#46;com/azure/virtual-machines/availability-set-overview)&#46; For more information on Azure planned maintenance, see [Maintenance and updates for Virtual Machines in Azure](https://docs.microsoft.com/azure/virtual-machines/maintenance-and-updates). Currently, a VM can only be added to an availability set at creation time. An existing VM cannot be added to an availability set.
 * Azure REST API version: 2023-03-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2016-04-30-preview, 2023-07-01, 2023-09-01.
 * ## Example Usage
 * ### Create an availability set.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var availabilitySet = new AzureNative.Compute.AvailabilitySet("availabilitySet", new()
 *     {
 *         AvailabilitySetName = "myAvailabilitySet",
 *         Location = "westus",
 *         PlatformFaultDomainCount = 2,
 *         PlatformUpdateDomainCount = 20,
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewAvailabilitySet(ctx, "availabilitySet", &compute.AvailabilitySetArgs{
 * 			AvailabilitySetName:       pulumi.String("myAvailabilitySet"),
 * 			Location:                  pulumi.String("westus"),
 * 			PlatformFaultDomainCount:  pulumi.Int(2),
 * 			PlatformUpdateDomainCount: pulumi.Int(20),
 * 			ResourceGroupName:         pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.AvailabilitySet;
 * import com.pulumi.azurenative.compute.AvailabilitySetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var availabilitySet = new AvailabilitySet("availabilitySet", AvailabilitySetArgs.builder()
 *             .availabilitySetName("myAvailabilitySet")
 *             .location("westus")
 *             .platformFaultDomainCount(2)
 *             .platformUpdateDomainCount(20)
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:compute:AvailabilitySet myAvailabilitySet /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}
 * ```
 */
public class AvailabilitySet internal constructor(
    override val javaResource: com.pulumi.azurenative.compute.AvailabilitySet,
) : KotlinCustomResource(javaResource, AvailabilitySetMapper) {
    /**
     * Resource location
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Fault Domain count.
     */
    public val platformFaultDomainCount: Output<Int>?
        get() = javaResource.platformFaultDomainCount().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Update Domain count.
     */
    public val platformUpdateDomainCount: Output<Int>?
        get() = javaResource.platformUpdateDomainCount().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies information about the proximity placement group that the availability set should be assigned to. Minimum api-version: 2018-04-01.
     */
    public val proximityPlacementGroup: Output<SubResourceResponse>?
        get() = javaResource.proximityPlacementGroup().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> subResourceResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Sku of the availability set, only name is required to be set. See AvailabilitySetSkuTypes for possible set of values. Use 'Aligned' for virtual machines with managed disks and 'Classic' for virtual machines with unmanaged disks. Default value is 'Classic'.
     */
    public val sku: Output<SkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    skuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The resource status information.
     */
    public val statuses: Output<List<InstanceViewStatusResponse>>
        get() = javaResource.statuses().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    instanceViewStatusResponseToKotlin(args0)
                })
            })
        })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * A list of references to all virtual machines in the availability set.
     */
    public val virtualMachines: Output<List<SubResourceResponse>>?
        get() = javaResource.virtualMachines().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        subResourceResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })
}

public object AvailabilitySetMapper : ResourceMapper<AvailabilitySet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.compute.AvailabilitySet::class == javaResource::class

    override fun map(javaResource: Resource): AvailabilitySet = AvailabilitySet(
        javaResource as
            com.pulumi.azurenative.compute.AvailabilitySet,
    )
}

/**
 * @see [AvailabilitySet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AvailabilitySet].
 */
public suspend fun availabilitySet(
    name: String,
    block: suspend AvailabilitySetResourceBuilder.() -> Unit,
): AvailabilitySet {
    val builder = AvailabilitySetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AvailabilitySet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun availabilitySet(name: String): AvailabilitySet {
    val builder = AvailabilitySetResourceBuilder()
    builder.name(name)
    return builder.build()
}
