@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin

import com.pulumi.azurenative.compute.kotlin.outputs.CapacityReservationGroupInstanceViewResponse
import com.pulumi.azurenative.compute.kotlin.outputs.SubResourceReadOnlyResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.compute.kotlin.outputs.CapacityReservationGroupInstanceViewResponse.Companion.toKotlin as capacityReservationGroupInstanceViewResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.SubResourceReadOnlyResponse.Companion.toKotlin as subResourceReadOnlyResponseToKotlin

/**
 * Builder for [CapacityReservationGroup].
 */
@PulumiTagMarker
public class CapacityReservationGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CapacityReservationGroupArgs = CapacityReservationGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CapacityReservationGroupArgsBuilder.() -> Unit) {
        val builder = CapacityReservationGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): CapacityReservationGroup {
        val builtJavaResource =
            com.pulumi.azurenative.compute.CapacityReservationGroup(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return CapacityReservationGroup(builtJavaResource)
    }
}

/**
 * Specifies information about the capacity reservation group that the capacity reservations should be assigned to. Currently, a capacity reservation can only be added to a capacity reservation group at creation time. An existing capacity reservation cannot be added or moved to another capacity reservation group.
 * Azure REST API version: 2023-03-01. Prior API version in Azure Native 1.x: 2021-04-01.
 * Other available API versions: 2023-07-01, 2023-09-01.
 * ## Example Usage
 * ### Create or update a capacity reservation group.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var capacityReservationGroup = new AzureNative.Compute.CapacityReservationGroup("capacityReservationGroup", new()
 *     {
 *         CapacityReservationGroupName = "myCapacityReservationGroup",
 *         Location = "westus",
 *         ResourceGroupName = "myResourceGroup",
 *         Tags =
 *         {
 *             { "department", "finance" },
 *         },
 *         Zones = new[]
 *         {
 *             "1",
 *             "2",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewCapacityReservationGroup(ctx, "capacityReservationGroup", &compute.CapacityReservationGroupArgs{
 * 			CapacityReservationGroupName: pulumi.String("myCapacityReservationGroup"),
 * 			Location:                     pulumi.String("westus"),
 * 			ResourceGroupName:            pulumi.String("myResourceGroup"),
 * 			Tags: pulumi.StringMap{
 * 				"department": pulumi.String("finance"),
 * 			},
 * 			Zones: pulumi.StringArray{
 * 				pulumi.String("1"),
 * 				pulumi.String("2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.CapacityReservationGroup;
 * import com.pulumi.azurenative.compute.CapacityReservationGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var capacityReservationGroup = new CapacityReservationGroup("capacityReservationGroup", CapacityReservationGroupArgs.builder()
 *             .capacityReservationGroupName("myCapacityReservationGroup")
 *             .location("westus")
 *             .resourceGroupName("myResourceGroup")
 *             .tags(Map.of("department", "finance"))
 *             .zones(
 *                 "1",
 *                 "2")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:compute:CapacityReservationGroup myCapacityReservationGroup /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/capacityReservationGroups/{capacityReservationGroupName}
 * ```
 */
public class CapacityReservationGroup internal constructor(
    override val javaResource: com.pulumi.azurenative.compute.CapacityReservationGroup,
) : KotlinCustomResource(javaResource, CapacityReservationGroupMapper) {
    /**
     * A list of all capacity reservation resource ids that belong to capacity reservation group.
     */
    public val capacityReservations: Output<List<SubResourceReadOnlyResponse>>
        get() = javaResource.capacityReservations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> subResourceReadOnlyResponseToKotlin(args0) })
            })
        })

    /**
     * The capacity reservation group instance view which has the list of instance views for all the capacity reservations that belong to the capacity reservation group.
     */
    public val instanceView: Output<CapacityReservationGroupInstanceViewResponse>
        get() = javaResource.instanceView().applyValue({ args0 ->
            args0.let({ args0 ->
                capacityReservationGroupInstanceViewResponseToKotlin(args0)
            })
        })

    /**
     * Resource location
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * A list of references to all virtual machines associated to the capacity reservation group.
     */
    public val virtualMachinesAssociated: Output<List<SubResourceReadOnlyResponse>>
        get() = javaResource.virtualMachinesAssociated().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> subResourceReadOnlyResponseToKotlin(args0) })
            })
        })

    /**
     * Availability Zones to use for this capacity reservation group. The zones can be assigned only during creation. If not provided, the group supports only regional resources in the region. If provided, enforces each capacity reservation in the group to be in one of the zones.
     */
    public val zones: Output<List<String>>?
        get() = javaResource.zones().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })
}

public object CapacityReservationGroupMapper : ResourceMapper<CapacityReservationGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.compute.CapacityReservationGroup::class == javaResource::class

    override fun map(javaResource: Resource): CapacityReservationGroup =
        CapacityReservationGroup(
            javaResource as
                com.pulumi.azurenative.compute.CapacityReservationGroup,
        )
}

/**
 * @see [CapacityReservationGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CapacityReservationGroup].
 */
public suspend fun capacityReservationGroup(
    name: String,
    block: suspend CapacityReservationGroupResourceBuilder.() -> Unit,
): CapacityReservationGroup {
    val builder = CapacityReservationGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CapacityReservationGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun capacityReservationGroup(name: String): CapacityReservationGroup {
    val builder = CapacityReservationGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
