@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin

import com.pulumi.azurenative.compute.CapacityReservationGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Specifies information about the capacity reservation group that the capacity reservations should be assigned to. Currently, a capacity reservation can only be added to a capacity reservation group at creation time. An existing capacity reservation cannot be added or moved to another capacity reservation group.
 * Azure REST API version: 2023-03-01. Prior API version in Azure Native 1.x: 2021-04-01.
 * Other available API versions: 2023-07-01, 2023-09-01.
 * ## Example Usage
 * ### Create or update a capacity reservation group.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var capacityReservationGroup = new AzureNative.Compute.CapacityReservationGroup("capacityReservationGroup", new()
 *     {
 *         CapacityReservationGroupName = "myCapacityReservationGroup",
 *         Location = "westus",
 *         ResourceGroupName = "myResourceGroup",
 *         Tags =
 *         {
 *             { "department", "finance" },
 *         },
 *         Zones = new[]
 *         {
 *             "1",
 *             "2",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewCapacityReservationGroup(ctx, "capacityReservationGroup", &compute.CapacityReservationGroupArgs{
 * 			CapacityReservationGroupName: pulumi.String("myCapacityReservationGroup"),
 * 			Location:                     pulumi.String("westus"),
 * 			ResourceGroupName:            pulumi.String("myResourceGroup"),
 * 			Tags: pulumi.StringMap{
 * 				"department": pulumi.String("finance"),
 * 			},
 * 			Zones: pulumi.StringArray{
 * 				pulumi.String("1"),
 * 				pulumi.String("2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.CapacityReservationGroup;
 * import com.pulumi.azurenative.compute.CapacityReservationGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var capacityReservationGroup = new CapacityReservationGroup("capacityReservationGroup", CapacityReservationGroupArgs.builder()
 *             .capacityReservationGroupName("myCapacityReservationGroup")
 *             .location("westus")
 *             .resourceGroupName("myResourceGroup")
 *             .tags(Map.of("department", "finance"))
 *             .zones(
 *                 "1",
 *                 "2")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:compute:CapacityReservationGroup myCapacityReservationGroup /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/capacityReservationGroups/{capacityReservationGroupName}
 * ```
 * @property capacityReservationGroupName The name of the capacity reservation group.
 * @property location Resource location
 * @property resourceGroupName The name of the resource group.
 * @property tags Resource tags
 * @property zones Availability Zones to use for this capacity reservation group. The zones can be assigned only during creation. If not provided, the group supports only regional resources in the region. If provided, enforces each capacity reservation in the group to be in one of the zones.
 */
public data class CapacityReservationGroupArgs(
    public val capacityReservationGroupName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val zones: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.CapacityReservationGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.CapacityReservationGroupArgs =
        com.pulumi.azurenative.compute.CapacityReservationGroupArgs.builder()
            .capacityReservationGroupName(capacityReservationGroupName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .zones(zones?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [CapacityReservationGroupArgs].
 */
@PulumiTagMarker
public class CapacityReservationGroupArgsBuilder internal constructor() {
    private var capacityReservationGroupName: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var zones: Output<List<String>>? = null

    /**
     * @param value The name of the capacity reservation group.
     */
    @JvmName("jhpaxtwnitgoofdl")
    public suspend fun capacityReservationGroupName(`value`: Output<String>) {
        this.capacityReservationGroupName = value
    }

    /**
     * @param value Resource location
     */
    @JvmName("kbnjwgpsqfjiorwc")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("eflwanocobcijjsp")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("miivlervvnyfdogx")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Availability Zones to use for this capacity reservation group. The zones can be assigned only during creation. If not provided, the group supports only regional resources in the region. If provided, enforces each capacity reservation in the group to be in one of the zones.
     */
    @JvmName("pflhkkrppnjifewh")
    public suspend fun zones(`value`: Output<List<String>>) {
        this.zones = value
    }

    @JvmName("fijuadkxjribawad")
    public suspend fun zones(vararg values: Output<String>) {
        this.zones = Output.all(values.asList())
    }

    /**
     * @param values Availability Zones to use for this capacity reservation group. The zones can be assigned only during creation. If not provided, the group supports only regional resources in the region. If provided, enforces each capacity reservation in the group to be in one of the zones.
     */
    @JvmName("ikmetflboxtmynim")
    public suspend fun zones(values: List<Output<String>>) {
        this.zones = Output.all(values)
    }

    /**
     * @param value The name of the capacity reservation group.
     */
    @JvmName("qmnqqcfeiyfdumyc")
    public suspend fun capacityReservationGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacityReservationGroupName = mapped
    }

    /**
     * @param value Resource location
     */
    @JvmName("atxypydhvmvhgaen")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("qverrcvhokhrfjas")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("wiileogiuwvjpegs")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("xqovqptpyswptula")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Availability Zones to use for this capacity reservation group. The zones can be assigned only during creation. If not provided, the group supports only regional resources in the region. If provided, enforces each capacity reservation in the group to be in one of the zones.
     */
    @JvmName("vuxaisfyyrepoqpf")
    public suspend fun zones(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    /**
     * @param values Availability Zones to use for this capacity reservation group. The zones can be assigned only during creation. If not provided, the group supports only regional resources in the region. If provided, enforces each capacity reservation in the group to be in one of the zones.
     */
    @JvmName("xjykdhtixofcyjay")
    public suspend fun zones(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    internal fun build(): CapacityReservationGroupArgs = CapacityReservationGroupArgs(
        capacityReservationGroupName = capacityReservationGroupName,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
        zones = zones,
    )
}
